/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.util;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class SimpleDOMBuilder {
    private Document dom = null;
    private Element currentElement = null;
    private StringBuilder charBuffer = new StringBuilder();

    public boolean startElement(String sTagName) {
        if (this.currentElement != null) {
            this.flushCharacters();
            this.currentElement = (Element)this.currentElement.appendChild(this.dom.createElement(sTagName));
        } else {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                DOMImplementation domImpl = builder.getDOMImplementation();
                DocumentType doctype = domImpl.createDocumentType(sTagName, "", "");
                this.dom = domImpl.createDocument("", sTagName, doctype);
                this.currentElement = this.dom.getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                return false;
            }
        }
        return true;
    }

    public boolean endElement() {
        if (this.currentElement != null) {
            this.flushCharacters();
            this.currentElement = this.currentElement != this.dom.getDocumentElement() ? (Element)this.currentElement.getParentNode() : null;
            return true;
        }
        return false;
    }

    public boolean setAttribute(String sName, String sValue) {
        if (this.currentElement != null) {
            this.currentElement.setAttribute(sName, sValue);
            return true;
        }
        return false;
    }

    public boolean characters(String sText) {
        if (this.currentElement != null) {
            this.charBuffer.append(sText);
            return true;
        }
        return false;
    }

    private void flushCharacters() {
        if (this.charBuffer.length() > 0) {
            this.currentElement.appendChild(this.dom.createTextNode(this.charBuffer.toString()));
            this.charBuffer.setLength(0);
        }
    }

    public Document getDOM() {
        return this.dom;
    }
}

