/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.OfficeStyle;
import writer2xhtml.office.PropertySet;
import writer2xhtml.util.Misc;

public class ListStyle
extends OfficeStyle {
    private static final int MAX_LEVEL = 10;
    private PropertySet[] level = new PropertySet[11];
    private PropertySet[] levelStyle = new PropertySet[11];
    private PropertySet[] levelStyleText = new PropertySet[11];
    private Element[] levelImage = new Element[11];

    public ListStyle() {
        for (int i = 1; i <= 10; ++i) {
            this.level[i] = new PropertySet();
            this.levelStyle[i] = new PropertySet();
            this.levelStyleText[i] = new PropertySet();
            this.levelImage[i] = null;
        }
    }

    public String getLevelType(int i) {
        if (i >= 1 && i <= 10) {
            return this.level[i].getName();
        }
        return null;
    }

    public boolean isNumber(int i) {
        return "text:list-level-style-number".equals(this.level[i].getName()) || "text:outline-level-style".equals(this.level[i].getName());
    }

    public boolean isBullet(int i) {
        return "text:list-level-style-bullet".equals(this.level[i].getName());
    }

    public boolean isImage(int i) {
        return "text:list-level-style-image".equals(this.level[i].getName());
    }

    public Element getImage(int i) {
        return this.levelImage[i];
    }

    public boolean isNewType(int i) {
        return "label-alignment".equals(this.getLevelStyleProperty(i, "text:list-level-position-and-space-mode"));
    }

    public String getLevelProperty(int i, String sName) {
        if (i >= 1 && i <= 10) {
            return this.level[i].getProperty(sName);
        }
        return null;
    }

    public String getLevelStyleProperty(int i, String sName) {
        if (i >= 1 && i <= 10) {
            return this.levelStyle[i].getProperty(sName);
        }
        return null;
    }

    public String getLevelStyleTextProperty(int i, String sName) {
        if (i >= 1 && i <= 10) {
            return this.levelStyleText[i].getProperty(sName);
        }
        return null;
    }

    @Override
    public void loadStyleFromDOM(Node node) {
        super.loadStyleFromDOM(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            int nLevel;
            String sLevel;
            if (child.getNodeType() != 1 || (sLevel = Misc.getAttribute(child, "text:level")) == null || (nLevel = Misc.getPosInteger(sLevel, 1)) < 1 || nLevel > 10) continue;
            this.loadLevelPropertiesFromDOM(nLevel, child);
            if (!"text:list-level-style-image".equals(child.getNodeName())) continue;
            this.levelImage[nLevel] = (Element)child;
        }
    }

    private void loadLevelPropertiesFromDOM(int nLevel, Node node) {
        this.level[nLevel].loadFromDOM(node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("style:properties")) {
                this.levelStyle[nLevel].loadFromDOM(child);
                this.loadLevelLabelPropertiesFromDOM(nLevel, node);
                continue;
            }
            if (child.getNodeName().equals("style:list-level-properties")) {
                this.levelStyle[nLevel].loadFromDOM(child);
                this.loadLevelLabelPropertiesFromDOM(nLevel, child);
                continue;
            }
            if (!child.getNodeName().equals("style:text-properties")) continue;
            this.levelStyleText[nLevel].loadFromDOM(child);
        }
    }

    private void loadLevelLabelPropertiesFromDOM(int nLevel, Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals("style:list-level-label-alignment")) continue;
            this.levelStyle[nLevel].loadFromDOM(child);
        }
    }
}

