/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import java.io.IOException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import writer2xhtml.office.EmbeddedObject;
import writer2xhtml.office.OfficeDocument;
import writer2xhtml.util.SimpleZipReader;

public class EmbeddedXMLObject
extends EmbeddedObject {
    private byte[] contentBytes = null;
    private byte[] stylesBytes = null;
    protected Document contentDOM = null;
    protected Document stylesDOM = null;

    protected EmbeddedXMLObject(String sName, String sType, OfficeDocument doc, SimpleZipReader source) {
        super(sName, sType, doc);
        this.contentBytes = source.getEntry(sName + "/" + "content.xml");
        this.stylesBytes = source.getEntry(sName + "/" + "styles.xml");
    }

    public Document getContentDOM() throws SAXException, IOException {
        if (this.contentDOM == null) {
            this.contentDOM = this.getDOM(this.contentBytes);
            this.contentBytes = null;
        }
        return this.contentDOM;
    }

    public Document getStylesDOM() throws SAXException, IOException {
        if (this.stylesDOM == null) {
            this.stylesDOM = this.getDOM(this.stylesBytes);
            this.stylesBytes = null;
        }
        return this.stylesDOM;
    }

    private Document getDOM(byte[] data) throws SAXException, IOException {
        if (data != null) {
            return OfficeDocument.parse(data);
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.contentBytes = null;
        this.stylesBytes = null;
        this.contentDOM = null;
        this.stylesDOM = null;
    }
}

