/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import writer2xhtml.util.Misc;

public final class BibMark {
    private String sIdentifier;
    private String sEntryType;
    private Map<EntryType, String> fields = new HashMap<EntryType, String>();

    public BibMark(String sIdentifier, String sEntryType) {
        this.sIdentifier = sIdentifier;
        this.sEntryType = sEntryType;
    }

    public BibMark(Node node) {
        this.sIdentifier = Misc.getAttribute(node, "text:identifier");
        this.sEntryType = Misc.getAttribute(node, "text:bibliography-type");
        if (this.sEntryType == null) {
            this.sEntryType = Misc.getAttribute(node, "text:bibiliographic-type");
        }
        this.fields.put(EntryType.address, Misc.getAttribute(node, "text:address"));
        this.fields.put(EntryType.annote, Misc.getAttribute(node, "text:annote"));
        this.fields.put(EntryType.author, Misc.getAttribute(node, "text:author"));
        this.fields.put(EntryType.booktitle, Misc.getAttribute(node, "text:booktitle"));
        this.fields.put(EntryType.chapter, Misc.getAttribute(node, "text:chapter"));
        this.fields.put(EntryType.edition, Misc.getAttribute(node, "text:edition"));
        this.fields.put(EntryType.editor, Misc.getAttribute(node, "text:editor"));
        this.fields.put(EntryType.howpublished, Misc.getAttribute(node, "text:howpublished"));
        this.fields.put(EntryType.institution, Misc.getAttribute(node, "text:institution"));
        this.fields.put(EntryType.journal, Misc.getAttribute(node, "text:journal"));
        this.fields.put(EntryType.month, Misc.getAttribute(node, "text:month"));
        this.fields.put(EntryType.note, Misc.getAttribute(node, "text:note"));
        this.fields.put(EntryType.number, Misc.getAttribute(node, "text:number"));
        this.fields.put(EntryType.organizations, Misc.getAttribute(node, "text:organizations"));
        this.fields.put(EntryType.pages, Misc.getAttribute(node, "text:pages"));
        this.fields.put(EntryType.publisher, Misc.getAttribute(node, "text:publisher"));
        this.fields.put(EntryType.school, Misc.getAttribute(node, "text:school"));
        this.fields.put(EntryType.series, Misc.getAttribute(node, "text:series"));
        this.fields.put(EntryType.title, Misc.getAttribute(node, "text:title"));
        this.fields.put(EntryType.report_type, Misc.getAttribute(node, "text:report-type"));
        this.fields.put(EntryType.volume, Misc.getAttribute(node, "text:volume"));
        this.fields.put(EntryType.year, Misc.getAttribute(node, "text:year"));
        this.fields.put(EntryType.url, Misc.getAttribute(node, "text:url"));
        this.fields.put(EntryType.custom1, Misc.getAttribute(node, "text:custom1"));
        this.fields.put(EntryType.custom2, Misc.getAttribute(node, "text:custom2"));
        this.fields.put(EntryType.custom3, Misc.getAttribute(node, "text:custom3"));
        this.fields.put(EntryType.custom4, Misc.getAttribute(node, "text:custom4"));
        this.fields.put(EntryType.custom5, Misc.getAttribute(node, "text:custom5"));
        this.fields.put(EntryType.isbn, Misc.getAttribute(node, "text:isbn"));
    }

    public String getIdentifier() {
        return this.sIdentifier;
    }

    public String getEntryType() {
        return this.sEntryType;
    }

    public void setField(EntryType entryType, String sValue) {
        this.fields.put(entryType, sValue);
    }

    public String getField(EntryType entryType) {
        return this.fields.containsKey((Object)entryType) ? this.fields.get((Object)entryType) : null;
    }

    public static enum EntryType {
        address,
        annote,
        author,
        booktitle,
        chapter,
        edition,
        editor,
        howpublished,
        institution,
        journal,
        month,
        note,
        number,
        organizations,
        pages,
        publisher,
        school,
        series,
        title,
        report_type,
        volume,
        year,
        url,
        custom1,
        custom2,
        custom3,
        custom4,
        custom5,
        isbn;

    }
}

