/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.epub;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import writer2xhtml.api.ContentEntry;
import writer2xhtml.api.ConverterResult;
import writer2xhtml.api.OutputFile;
import writer2xhtml.base.DOMDocument;
import writer2xhtml.util.Misc;
import writer2xhtml.xhtml.XhtmlConfig;

public class OPFWriter
extends DOMDocument {
    private String sUID = null;

    public OPFWriter(ConverterResult cr, String sFileName, int nVersion, XhtmlConfig config) {
        super("book", "opf");
        Element item;
        Element meta;
        String[] sKeys;
        Document contentDOM = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType doctype = domImpl.createDocumentType("package", "", "");
            contentDOM = domImpl.createDocument("http://www.idpf.org/2007/opf", "package", doctype);
        }
        catch (ParserConfigurationException t) {
            throw new RuntimeException(t);
        }
        Element pack = contentDOM.getDocumentElement();
        if (nVersion == 3) {
            pack.setAttribute("version", "3.0");
        } else {
            pack.setAttribute("version", "2.0");
        }
        pack.setAttribute("xmlns", "http://www.idpf.org/2007/opf");
        pack.setAttribute("unique-identifier", "BookId");
        Element metadata = contentDOM.createElement("metadata");
        metadata.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        if (nVersion != 3) {
            metadata.setAttribute("xmlns:opf", "http://www.idpf.org/2007/opf");
        }
        pack.appendChild(metadata);
        String sTitle = cr.getMetaData().getTitle();
        this.appendElement(contentDOM, metadata, "dc:title", sTitle.trim().length() > 0 ? sTitle : sFileName);
        this.appendElement(contentDOM, metadata, "dc:language", cr.getMetaData().getLanguage());
        if (nVersion == 3) {
            this.appendElement(contentDOM, metadata, "meta", this.getCurrentDateTime()).setAttribute("property", "dcterms:modified");
        }
        if (cr.getMetaData().getSubject().length() > 0) {
            this.appendElement(contentDOM, metadata, "dc:subject", cr.getMetaData().getSubject());
        }
        if (cr.getMetaData().getKeywords().length() > 0) {
            String[] sKeywords;
            for (String sKeyword : sKeywords = cr.getMetaData().getKeywords().split(",")) {
                this.appendElement(contentDOM, metadata, "dc:subject", sKeyword.trim());
            }
        }
        if (cr.getMetaData().getDescription().length() > 0) {
            this.appendElement(contentDOM, metadata, "dc:description", cr.getMetaData().getDescription());
        }
        boolean bHasIdentifier = false;
        boolean bHasCreator = false;
        boolean bHasDate = false;
        Map<String, String> userDefinedMetaData = cr.getMetaData().getUserDefinedMetaData();
        HashMap<String, String[]> dc = new HashMap<String, String[]>();
        for (String string : userDefinedMetaData.keySet()) {
            String sNewKey;
            if (string.length() <= 0) continue;
            String[] sValue = new String[2];
            sValue[0] = userDefinedMetaData.get(string);
            int nDot = string.indexOf(".");
            if (nDot > 0) {
                sNewKey = string.substring(0, nDot).toLowerCase();
                sValue[1] = string.substring(nDot + 1);
            } else {
                sNewKey = string.toLowerCase();
                sValue[1] = null;
            }
            dc.put(sNewKey, sValue);
        }
        for (String sKey : sKeys = Misc.sortStringSet(dc.keySet())) {
            Element role;
            Element fileas;
            String sValue = ((String[])dc.get(sKey))[0];
            String sAttributeValue = ((String[])dc.get(sKey))[1];
            if (sKey.startsWith("identifier")) {
                Element identifier = this.appendElement(contentDOM, metadata, "dc:identifier", sValue);
                if (!bHasIdentifier) {
                    identifier.setAttribute("id", "BookId");
                    this.sUID = sValue;
                }
                if (sAttributeValue != null) {
                    if (nVersion == 3) {
                        meta = this.appendElement(contentDOM, metadata, "meta", sAttributeValue);
                        meta.setAttribute("refines", "#BookId");
                        meta.setAttribute("property", "identifier-type");
                    } else {
                        identifier.setAttribute("opf:scheme", sAttributeValue);
                    }
                }
                bHasIdentifier = true;
                continue;
            }
            if (sKey.startsWith("creator")) {
                Element creator = this.appendElement(contentDOM, metadata, "dc:creator", sValue);
                creator.setAttribute("id", sKey);
                if (nVersion == 3) {
                    fileas = this.appendElement(contentDOM, metadata, "meta", this.fileAs(sValue));
                    fileas.setAttribute("refines", "#" + sKey);
                    fileas.setAttribute("property", "file-as");
                    if (sAttributeValue != null) {
                        role = this.appendElement(contentDOM, metadata, "meta", sAttributeValue);
                        role.setAttribute("refines", "#" + sKey);
                        role.setAttribute("property", "role");
                    }
                } else {
                    creator.setAttribute("opf:file-as", this.fileAs(sValue));
                    if (sAttributeValue != null) {
                        creator.setAttribute("opf:role", sAttributeValue);
                    }
                }
                bHasCreator = true;
                continue;
            }
            if (sKey.startsWith("contributor")) {
                Element contributor = this.appendElement(contentDOM, metadata, "dc:contributor", sValue);
                contributor.setAttribute("id", sKey);
                if (nVersion == 3) {
                    fileas = this.appendElement(contentDOM, metadata, "meta", this.fileAs(sValue));
                    fileas.setAttribute("refines", "#" + sKey);
                    fileas.setAttribute("property", "file-as");
                    if (sAttributeValue == null) continue;
                    role = this.appendElement(contentDOM, metadata, "meta", sAttributeValue);
                    role.setAttribute("refines", "#" + sKey);
                    role.setAttribute("property", "role");
                    continue;
                }
                contributor.setAttribute("opf:file-as", this.fileAs(sValue));
                if (sAttributeValue == null) continue;
                contributor.setAttribute("opf:role", sAttributeValue);
                continue;
            }
            if (sKey.startsWith("date")) {
                Element date = this.appendElement(contentDOM, metadata, "dc:date", sValue);
                date.setAttribute("id", sKey);
                if (nVersion == 3) {
                    if (sAttributeValue != null) {
                        Element event = this.appendElement(contentDOM, metadata, "meta", sAttributeValue);
                        event.setAttribute("refines", "#" + sKey);
                        event.setAttribute("property", "event");
                    }
                } else if (sAttributeValue != null) {
                    date.setAttribute("opf:event", sAttributeValue);
                }
                bHasDate = true;
                continue;
            }
            if (sAttributeValue != null) continue;
            if ("publisher".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:publisher", sValue);
                continue;
            }
            if ("type".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:type", sValue);
                continue;
            }
            if ("format".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:format", sValue);
                continue;
            }
            if ("source".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:source", sValue);
                continue;
            }
            if ("relation".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:relation", sValue);
                continue;
            }
            if ("coverage".equals(sKey)) {
                this.appendElement(contentDOM, metadata, "dc:coverage", sValue);
                continue;
            }
            if (!"rights".equals(sKey)) continue;
            this.appendElement(contentDOM, metadata, "dc:rights", sValue);
        }
        if (!bHasIdentifier) {
            this.sUID = UUID.randomUUID().toString();
            Element element = this.appendElement(contentDOM, metadata, "dc:identifier", this.sUID);
            element.setAttribute("id", "BookId");
            if (nVersion == 3) {
                Element meta2 = this.appendElement(contentDOM, metadata, "meta", "UUID");
                meta2.setAttribute("refines", "#BookId");
                meta2.setAttribute("property", "identifier-type");
            } else {
                element.setAttribute("opf:scheme", "UUID");
            }
        }
        if (!bHasCreator && cr.getMetaData().getCreator().length() > 0) {
            Element element = this.appendElement(contentDOM, metadata, "dc:creator", cr.getMetaData().getCreator());
            element.setAttribute("id", "creator");
            if (nVersion == 3) {
                Element fileas = this.appendElement(contentDOM, metadata, "meta", this.fileAs(cr.getMetaData().getCreator()));
                fileas.setAttribute("refines", "#creator");
                fileas.setAttribute("property", "file-as");
            } else {
                element.setAttribute("opf:file-as", this.fileAs(cr.getMetaData().getCreator()));
            }
        }
        if (!bHasDate && cr.getMetaData().getDate().length() > 0) {
            this.appendElement(contentDOM, metadata, "dc:date", Misc.dateOnly(cr.getMetaData().getDate()));
        }
        Element element = contentDOM.createElement("manifest");
        pack.appendChild(element);
        Element spine = contentDOM.createElement("spine");
        if (nVersion != 3 || config.includeNCX()) {
            spine.setAttribute("toc", "ncx");
        }
        pack.appendChild(spine);
        int nMasterCount = 0;
        int nResourceCount = 0;
        Iterator<OutputFile> iterator = cr.iterator();
        while (iterator.hasNext()) {
            OutputFile file = iterator.next();
            Element item2 = contentDOM.createElement("item");
            element.appendChild(item2);
            item2.setAttribute("href", Misc.makeHref(file.getFileName()));
            item2.setAttribute("media-type", file.getMIMEType());
            if (cr.getCoverFile() != null && cr.getCoverFile().getFile() == file) {
                item2.setAttribute("id", "cover");
                Element itemref = contentDOM.createElement("itemref");
                itemref.setAttribute("idref", "cover");
                spine.appendChild(itemref);
                continue;
            }
            if (cr.getCoverImageFile() != null && cr.getCoverImageFile().getFile() == file) {
                item2.setAttribute("id", "cover-image");
                if (nVersion == 3) {
                    item2.setAttribute("properties", "cover-image");
                }
                meta = contentDOM.createElement("meta");
                meta.setAttribute("name", "cover");
                meta.setAttribute("content", "cover-image");
                metadata.appendChild(meta);
                continue;
            }
            if (file.isMasterDocument()) {
                String sId = "text" + ++nMasterCount;
                item2.setAttribute("id", sId);
                if (nVersion == 3 && file.containsMath()) {
                    item2.setAttribute("properties", "mathml");
                }
                Element itemref = contentDOM.createElement("itemref");
                itemref.setAttribute("idref", sId);
                spine.appendChild(itemref);
                continue;
            }
            item2.setAttribute("id", "resource" + ++nResourceCount);
        }
        if (nVersion == 3) {
            item = contentDOM.createElement("item");
            item.setAttribute("href", "nav.xhtml");
            item.setAttribute("media-type", "application/xhtml+xml");
            item.setAttribute("id", "nav");
            item.setAttribute("properties", "nav");
            element.appendChild(item);
        }
        if (nVersion != 3 || config.includeNCX()) {
            item = contentDOM.createElement("item");
            item.setAttribute("href", "book.ncx");
            item.setAttribute("media-type", "application/x-dtbncx+xml");
            item.setAttribute("id", "ncx");
            element.appendChild(item);
        }
        Element guide = contentDOM.createElement("guide");
        pack.appendChild(guide);
        this.addGuideReference(contentDOM, guide, "cover", cr.getCoverFile());
        this.addGuideReference(contentDOM, guide, "title-page", cr.getTitlePageFile());
        this.addGuideReference(contentDOM, guide, "text", cr.getTextFile());
        this.addGuideReference(contentDOM, guide, "toc", cr.getTocFile());
        this.addGuideReference(contentDOM, guide, "index", cr.getIndexFile());
        this.addGuideReference(contentDOM, guide, "loi", cr.getLofFile());
        this.addGuideReference(contentDOM, guide, "lot", cr.getLotFile());
        this.addGuideReference(contentDOM, guide, "bibliography", cr.getBibliographyFile());
        this.setContentDOM(contentDOM);
    }

    public String getUid() {
        return this.sUID;
    }

    private String fileAs(String sName) {
        int nSpace = sName.lastIndexOf(32);
        if (nSpace > -1) {
            return sName.substring(nSpace + 1).trim() + ", " + sName.substring(0, nSpace).trim();
        }
        return sName.trim();
    }

    private Element appendElement(Document contentDOM, Element node, String sTagName, String sContent) {
        Element child = contentDOM.createElement(sTagName);
        node.appendChild(child);
        child.appendChild(contentDOM.createTextNode(sContent));
        return child;
    }

    private void addGuideReference(Document contentDOM, Element guide, String sType, ContentEntry entry) {
        if (entry != null) {
            Element reference = contentDOM.createElement("reference");
            reference.setAttribute("type", sType);
            reference.setAttribute("title", entry.getTitle());
            String sHref = Misc.makeHref(entry.getFile().getFileName());
            if (entry.getTarget() != null) {
                sHref = sHref + "#" + entry.getTarget();
            }
            reference.setAttribute("href", sHref);
            guide.appendChild(reference);
        }
    }

    private String getCurrentDateTime() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(date);
    }
}

