/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.epub;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import writer2xhtml.api.ContentEntry;
import writer2xhtml.api.ConverterResult;
import writer2xhtml.base.DOMDocument;
import writer2xhtml.util.Misc;

public class NavigationWriter
extends DOMDocument {
    public NavigationWriter(ConverterResult cr, boolean bCreatePageList) {
        super("nav", "xhtml");
        Element a;
        Document contentDOM = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType doctype = domImpl.createDocumentType("xhtml", "", "");
            contentDOM = domImpl.createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
        }
        catch (ParserConfigurationException t) {
            throw new RuntimeException(t);
        }
        Element doc = contentDOM.getDocumentElement();
        doc.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        doc.setAttribute("xmlns:epub", "http://www.idpf.org/2007/ops");
        doc.setAttribute("xml:lang", cr.getMetaData().getLanguage());
        doc.setAttribute("lang", cr.getMetaData().getLanguage());
        Element head = contentDOM.createElement("head");
        doc.appendChild(head);
        Element title = contentDOM.createElement("title");
        head.appendChild(title);
        title.appendChild(contentDOM.createTextNode("EPUB 3 Navigation Document"));
        Element body = contentDOM.createElement("body");
        doc.appendChild(body);
        Element nav = contentDOM.createElement("nav");
        nav.setAttribute("epub:type", "toc");
        body.appendChild(nav);
        Element currentContainer = body;
        int nCurrentLevel = 0;
        int nCurrentEntryLevel = 0;
        for (ContentEntry entry : cr.getContent()) {
            int nEntryLevel = Math.max(entry.getLevel(), 1);
            if (nEntryLevel < nCurrentLevel) {
                for (int i = nEntryLevel; i < nCurrentLevel; ++i) {
                    currentContainer = (Element)currentContainer.getParentNode().getParentNode();
                }
                nCurrentLevel = nEntryLevel;
            } else if (nEntryLevel > nCurrentEntryLevel) {
                currentContainer = (Element)currentContainer.getLastChild();
                Element ol = contentDOM.createElement("ol");
                currentContainer.appendChild(ol);
                currentContainer = ol;
                ++nCurrentLevel;
            }
            nCurrentEntryLevel = nEntryLevel;
            Element li = contentDOM.createElement("li");
            currentContainer.appendChild(li);
            Element a2 = contentDOM.createElement("a");
            li.appendChild(a2);
            String sHref = Misc.makeHref(entry.getFile().getFileName());
            if (entry.getTarget() != null) {
                sHref = sHref + "#" + entry.getTarget();
            }
            a2.setAttribute("href", sHref);
            a2.appendChild(contentDOM.createTextNode(entry.getTitle()));
        }
        if (bCreatePageList && !cr.getOriginalPageNumbers().isEmpty()) {
            Element navPage = contentDOM.createElement("nav");
            navPage.setAttribute("epub:type", "page-list");
            navPage.setAttribute("hidden", "hidden");
            body.appendChild(navPage);
            Element ol = contentDOM.createElement("ol");
            navPage.appendChild(ol);
            for (ContentEntry entry : cr.getOriginalPageNumbers()) {
                Element li = contentDOM.createElement("li");
                ol.appendChild(li);
                Element a3 = contentDOM.createElement("a");
                li.appendChild(a3);
                String sHref = Misc.makeHref(entry.getFile().getFileName());
                if (entry.getTarget() != null) {
                    sHref = sHref + "#" + entry.getTarget();
                }
                a3.setAttribute("href", sHref);
                a3.appendChild(contentDOM.createTextNode(entry.getTitle()));
            }
        }
        nav = contentDOM.createElement("nav");
        nav.setAttribute("epub:type", "landmarks");
        nav.setAttribute("id", "landmarks");
        nav.setAttribute("hidden", "");
        body.appendChild(nav);
        Element ol = contentDOM.createElement("ol");
        nav.appendChild(ol);
        if (cr.getCoverFile() != null) {
            Element li = contentDOM.createElement("li");
            a = contentDOM.createElement("a");
            a.setAttribute("epub:type", "cover");
            a.setAttribute("href", Misc.makeHref(cr.getCoverFile().getFile().getFileName()));
            a.appendChild(contentDOM.createTextNode("cover"));
            li.appendChild(a);
            ol.appendChild(li);
        }
        if (cr.getTocFile() != null) {
            Element li = contentDOM.createElement("li");
            a = contentDOM.createElement("a");
            a.setAttribute("epub:type", "toc");
            a.setAttribute("href", Misc.makeHref(cr.getTocFile().getFile().getFileName()));
            a.appendChild(contentDOM.createTextNode("toc"));
            li.appendChild(a);
            ol.appendChild(li);
        }
        if (cr.getTextFile() != null) {
            Element li = contentDOM.createElement("li");
            a = contentDOM.createElement("a");
            a.setAttribute("epub:type", "bodymatter");
            a.setAttribute("href", Misc.makeHref(cr.getTextFile().getFile().getFileName()));
            a.appendChild(contentDOM.createTextNode("bodymatter"));
            li.appendChild(a);
            ol.appendChild(li);
        }
        this.setContentDOM(contentDOM);
    }
}

