#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab
import sys, os, re, shutil, platform, tempfile, imghdr, locale
from PIL import ImageTk, Image
from os.path import expanduser
# Add GUI Interface Tool
#import tkinter.ttk as tkinter_ttk
#import tkinter.constants as tkinter_constants
#from tkinter import *

if sys.platform.startswith('win'):
    os_encoding = locale.getpreferredencoding()
else:
    os_encoding = 'utf-8'

#------------------------------------
# display ImageMagick file selection dialog
#------------------------------------
def GetFileName():
    ''' displays the ImageMagick file selection dialog '''
    # requires Sigil 0.9.8 or higher or PyQt6/PySide6
    home = expanduser('~')
    from PySide6.QtWidgets import QApplication, QWidget, QFileDialog
    app = QApplication(sys.argv)
    w = QWidget()
    file_path, filter = QFileDialog.getOpenFileName(w,'Select ImageMagick exe-file', home, 'ImageMagick-Executable (magick.exe)')
   
    return file_path


# wrapper for ImageMagick
def im_wrapper(*args):
    ''' a wrapper for ImageMagick '''
    import subprocess
    startupinfo = None

    # stop the windows console popping up every time the prog is run
    if sys.platform.startswith('win'):
        startupinfo = subprocess.STARTUPINFO()
        startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
        startupinfo.wShowWindow = subprocess.SW_HIDE

    process = subprocess.Popen(list(args), stdout=subprocess.PIPE, stderr=subprocess.PIPE, startupinfo=startupinfo)
    stdout, stderr = process.communicate()

    returncode = process.returncode
    return stdout.decode('utf-8', 'ignore'), stderr.decode('utf-8', 'ignore'), returncode

# main routine
def run(bk):
    ''' the main routine '''

    #---------------------------------
    # get preferences
    #---------------------------------
    prefs = bk.getPrefs()
    
    # Original Default Prefs
    ##if prefs == {}:
    ##  prefs['maxWidth'] = '600';
    ##  prefs['debug'] = False;
    ##  bk.savePrefs(prefs)
    # New Default Prefs
    if prefs == {}:
      prefs['#Maxes-Options'] = 'To use {maxHeight} or {maxWidth} ONLY remove the other, do NOT set to 0 or None. All "#"Fields are used only as a guide & can be removed';
      prefs['#Maxes-Option2'] = 'All images larger than those dimensions will be shrunk to fit inside. 1200x2000 will result in 540x900 with the defaults 600x900 set';
      prefs['#Maxes-Option3'] = '{largerSize}=`true` Will use the larger dimension (1200x2000 gives 600x1000 with the defaults 600x900 set) ###Default=False if not declared';
      prefs['maxWidth'] = '600';
      prefs['maxHeight'] = '900';
      prefs['largerSize'] = False;
      prefs['#Quality-JPEG'] = 'JPEG= Quality Level 1-100 if qualityNum is removed original quality is preserved if detected, 92 if not per ImageMagick standard';
      prefs['#Quality-PNG'] = 'PNG= Compression Level <10=0,10-19=1,20-29=2,90-99=9 ###Default=Unused if not declared';
      prefs['qualityNum'] = '90';
      prefs['#TallImage-Options'] = 'true=rotate all WIDE images 90° CounterClockwize, for other options use `false` & set customArg. ###Default=False if not declared';
      prefs['tallImages'] = False;
      prefs['#Trim-Options'] = '{trimMaps} & {trimComics} IMGs named [Map]|||[Comics] or [Manga] (case ignored) will trim solid borders ###Default=False if not declared';
      prefs['trimMaps'] = False;
      prefs['trimComic'] = False;
      prefs['#Grayscale-Instructions'] = 'colorGray=0 (No conversion), colorGray=1 (-colorspace Gray), colorGray=2 (-colorspace LinearGray), colorGray=3 (-grayscale rec601luma), colorGray=4 (-grayscale rec709luma)';
      prefs['#Grayscale-Instructions2'] = 'I do not use this option personally, these options are available but from personal experiece reduce filesize by little & if indexed can INCREASE filesize';
      prefs['#Grayscale-Instructions2a'] = '1-Gray gives a grayscale MOST will want, 2-LinearGray gives a darker image but clearer text, 3-601Luma seems to give better seperation of similar colors like gradients, 4-709Luma should be identical to Gray';
      prefs['#Grayscale-Instructions3'] = 'I suggest testing them 1-4, & choosing which works best for your needs, but be aware what works best for 1 book might not for another ###Default=0 if not declared';
      prefs['colorGray'] = 0;
      prefs['#Custom-Instructions'] = 'Include any arguments from `imagemagick.org/script/mogrify.php` ###Preset=-filter Lanczos (Best for image downscaling)';
      prefs['#Custom-Instructions2'] = 'Arguments will be added in the order listed ###Default= Will not be used if not declared';
      prefs['#Custom-Order'] = '{magick_exe_path} mogrify -quality {qualityNum} -colorspace Gray $$${customArg}$$$ -rotate `-90>`$ -strip -resize {maxWidth}x{maxHeight} -path {temp_dir} {original_img_path}';
      prefs['customArg'] = '-filter Lanczos';
      prefs['#CommentRemoval-Options'] = 'Set `False` to NOT remove any comments or text chunks from images (they are useless for an ePUB I think). ###Default=True if not declared';
      prefs['stripComments'] = True;
      prefs['debug'] = False;
      bk.savePrefs(prefs)
    

    # Get ImageMagick path
    magick_exe_path = None
    magick_exe_path = prefs.get('magick_exe_path', None)
    if not magick_exe_path or not os.path.isfile(magick_exe_path):
        magick_exe_path = GetFileName()
        if magick_exe_path:
            prefs['magick_exe_path'] = magick_exe_path
            bk.savePrefs(prefs)


    # get pref values
    magick_exe_path = prefs.get('magick_exe_path', None)
    debug = prefs.get('debug', False) # show debug messages
    maxWidth = prefs.get('maxWidth', '7777777')
    maxHeight = prefs.get('maxHeight',' ')
    if maxWidth != '7777777':
        maxWidthy = maxWidth
    else:
        maxWidthy = ' '
    largerSize = prefs.get('largerSize', False)
    if largerSize == True:
        maxSize = f"{maxWidthy}x{maxHeight}^"
    else:
        maxSize = f"{maxWidthy}x{maxHeight}"
    qualityNum = prefs.get('qualityNum','null')
    tallImages = prefs.get('tallImages','False')
    customArg = prefs.get('customArg','ignore')
    if customArg != 'ignore':
        argList = [ele for x in customArg.split(',') for ele in x.split()]
    stripComments = prefs.get('stripComments','True')
    trimMaps = prefs.get('trimMaps','False')
    trimComics = prefs.get('trimComics','False')
    colorGray = prefs.get('colorGray',0)



    # make sure that the ImageMagick binary was found
    if not magick_exe_path or not os.path.isfile(magick_exe_path): 
        print('ImageMagick binary not found!\nPlease check path in pref.\nClick OK to close the Plugin Runner window.')
        return -1

    # get ebook root folder
    ebook_root = bk._w.ebook_root

    # get os temp folder
    temp_dir = tempfile.gettempdir()

    # get img_files
    img_manifest_items = []
    for manifest_id, href, mime in bk.manifest_iter():
        if mime == "image/jpeg" or mime == "image/png":
            img_manifest_items.append((manifest_id, href, mime))
    
    if img_manifest_items == []:
        print('No img files found.\nClick OK to close the Plugin Runner window.')
        return 0

    # process all manifested jpeg/png files in the Images folder
    bytes_saved = 0
    for manifest_id, href, mime in img_manifest_items:
        img_file_name = os.path.basename(href)
        processed_file_path = os.path.join(temp_dir, img_file_name)

        # Sigil 1.x and higher supports custom image paths
        if  bk.launcher_version() >= 20190927:
            original_img_path = os.path.abspath(os.path.join(ebook_root, bk.id_to_bookpath(manifest_id)))
        else:
            original_img_path = os.path.abspath(os.path.join(ebook_root, 'OEBPS', href))

        # double-check the file header to make sure it's really a img file
        # using pillow instead of imghdr 
        im = Image.open(original_img_path)
        (w,h) = im.size
        imgFormat = im.format
        # get pref values based on Original Image
        fileStats = os.stat(original_img_path)
        fileSize = fileStats.st_size
        trimSize = f"trim:minSize={int(w*0.9)}x{int(h*0.9)}"
        
        # Check if Image should be processed
        # Is Image smaller than max file size? & Is image larger than 100kb
        if maxWidth != '7777777':
            if ((imgFormat != 'JPEG') and (imgFormat != 'PNG')) or w <= int(maxWidth) or int(fileSize) < 100000:
                if debug: print('Ignoring: ', img_file_name, '(',int(fileSize/1024),'KB)' ' is a {} file; Width= {}\n'.format(imgFormat, w))
                continue
        else:
            if ((imgFormat != 'JPEG') and (imgFormat != 'PNG')) or h <= int(maxHeight) or int(fileSize) < 100000:
                if debug: print('Ignoring: ', img_file_name, '(',int(fileSize/1024),'KB)' ' is a {} file; Height= {}\n'.format(imgFormat, h))
                continue
        
        # assemble args
          # Opening Arguments
        args = [magick_exe_path, 'mogrify']
          # Check & add Image Quality
        if qualityNum != 'null':
            args.extend(['-quality', qualityNum])
          # Check & add Map Trim
        if "map" in original_img_path.lower() and trimMaps == True:
            args.extend(['-fuzz', '18%', '-trim'])
          # Check & add Comic/Manga Trim
        if "manga" in original_img_path.lower() or "comic" in original_img_path.lower() and trimComics == True:
            args.extend(['-fuzz', '1%', '-gravity', 'Center', '-define', trimSize, '-trim'])
          # Check for Grayscale Conversion
        if colorGray != '0':
            if colorGray == 1:
                args.extend(['-colorspace', 'Gray'])
            if colorGray == 2:
                args.extend(['-colorspace', 'LinearGray'])
            if colorGray == 3:
                args.extend(['-grayscale', 'rec601luma'])
            if colorGray == 4:
                args.extend(['-grayscale', 'rec709luma'])
            if colorGray == '1':
                args.extend(['-colorspace', 'Gray'])
            if colorGray == '2':
                args.extend(['-colorspace', 'LinearGray'])
            if colorGray == '3':
                args.extend(['-grayscale', 'rec601luma'])
            if colorGray == '4':
                args.extend(['-grayscale', 'rec709luma'])
          # Check & add Custom Arguments
        if customArg != 'ignore':
            args.extend(argList)
          # Check & add Tall Image Rotation
        if tallImages == True:
            args.extend(['-rotate', "-90>"])
          # Check & add Comment Stripping
        if stripComments == True:
            args.extend(['-strip'])
          # Closing Arguments
        args.extend(['-resize', maxSize,'-path', temp_dir, original_img_path])

        # run ImageMagick
        print('\nresizing: {} ...'.format(img_file_name))
        if debug: print(args)
        stdout, stderr, returncode = im_wrapper(*args)

        # display error messages, if ImageMagick failed
        if returncode != 0:
            print('ImageMagick failed!\n{}\nClick OK to close the Plugin Runner window'.format(stdout + stderr, returncode))
            return -1

        # check whether ImageMagick created an optimized file
        if os.path.isfile(processed_file_path):
            with open(processed_file_path, 'rb') as file:
                 optimized_image_data = file.read()
            bk.writefile(manifest_id, optimized_image_data)
            print('Image replaced with resized image.')

            # delete temp file
            os.remove(processed_file_path)
        else:
            # if there's no output file, optimized and original files sizes are identical
            print(stderr)
            print('Skipped')

    # display endmessage
    print('\nDone.\nClick OK to close the Plugin Runner window.')

    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
