#!/bin/bash
#
# Display the current date/time in digital form at the top of the
# screen.
IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")
LOGFILE="${INSTALLROOT}/log/showtime"

source "${INSTALLROOT}/lib/sh/fn_logger.sh"

lipc-send-event com.kindleautox.screensaver showtime -i $$
data=$(lipc-wait-event -s 10 com.kindleautox.screensaver "showtimedone$$" 2>&1)
if [[ $? -ne 0 ]]
then
    fn_logger_logerr "$CMD" "lipc-wait-event timed out or failed (error=${data}); is processevents.sh running?" 2>>"${LOGFILE}"
fi

status=$(echo "${data}" | cut '-d ' -f1)
if [[ "${status}" -ne 0 ]]
then
    if [[ "${status}" -eq 2 ]]
    then
        error=$(echo "${data}" | cut '-d"' -f2)
        fn_logger_logerr "$CMD" "showimage request failed, error = \"${error}\"" 2>>"${LOGFILE}"
    # else, ${status} should equal 1, implying that the request
    # wasn't serviced for some non-fatal reason, such as not
    # being in screensaver mode. In this case, we still want
    # to exit with a non-zero exit status.
    fi
    exit 1
fi
