#!/bin/bash
#
# Dipsplay a random screen saver image and the current date/time in
# digital form at the top. Calls showtime.sh to display the date/time.
IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")
IMAGEPATH="${INSTALLROOT}/screensaver/images"
LOGFILE="${INSTALLROOT}/log/showimage"

source "${INSTALLROOT}/config/config.sh"
source "${INSTALLROOT}/lib/sh/fn_logger.sh"

# busybox bash does not support arrays.
# Therefore, we mimic them using regular variables.
#declare -a images     # NOT SUPPORTED

# NOT SUPPORTED (assigning ls output to the "images" array such
# that each line becomes an entry in the array.
# OIFS="$IFS"; IFS=$'\n'; images=($(ls -1 ${IMAGEPATH} 2>/dev/null)); IFS="$OIFS"
# numimages=${#images[@]}

image=$(${INSTALLROOT}/bin/getrandomfile.awk "${IMAGEPATH}")
if [[ ! -z "${image}" ]]
then
    lipc-send-event com.kindleautox.screensaver showimage -i $$ -s "${image}"
    data=$(lipc-wait-event -s 15 com.kindleautox.screensaver "showimagedone$$" 2>&1)
    if [[ $? -ne 0 ]]
    then
        fn_logger_logerr "$CMD" "lipc-wait-event for showimagedone event timed out or failed (error=${data}); is processevents.sh running?" 2>>"${LOGFILE}"
        exit 1
    fi

    status=$(echo "${data}" | cut '-d ' -f1)
    if [[ "${status}" -ne 0 ]]
    then
        if [[ "${status}" -eq 2 ]]
        then
            error=$(echo "${data}" | cut '-d"' -f2)
            fn_logger_logerr "$CMD" "showimage request failed, error = \"${error}\"" 2>>"${LOGFILE}"
        # else, ${status} should equal 1, implying that the request
        # wasn't serviced for some non-fatal reason, such as not
        # being in screensaver mode. In this case, we still don't want to
        # invoke showtime because it too would probably fail for the same
        # reason. We also want to exit with a non-zero exit status.
        fi
        exit 1
    fi
    
    # Without the sleep below, we can end up seeing the following error:
    #
    # Failed to open LIPC
    # com.kindleautox.screensaver failed to send event showtime
    #
    sleep 1
    lipc-send-event com.kindleautox.screensaver showtime -i $$
    data=$(lipc-wait-event -s 15 com.kindleautox.screensaver "showtimedone$$" 2>&1)
    if [[ $? -ne 0 ]]
    then
        fn_logger_logerr "$CMD" "lipc-wait-event for showtimedone event timed out or failed (error=${data}); is processevents.sh running?" 2>>"${LOGFILE}"
        exit 1
    fi

    status=$(echo "${data}" | cut '-d ' -f1)
    if [[ "${status}" -ne 0 ]]
    then
        if [[ "${status}" -eq 2 ]]
        then
            error=$(echo "${data}" | cut '-d"' -f2)
            fn_logger_logerr "$CMD" "showtime request failed, error = \"${error}\"" 2>>"${LOGFILE}"
        fi
        exit 1
    fi
# else, no images exist.
fi

