#!/usr/bin/awk -f
#
# Identify a random screen save image file from the "images"
# directory to display. The 
#
# usage: getImage.awk imagepath
#
# where:
#
# imagepath is the path to the directory that contains the images.
#
# imagepath should contain only .png files. If imagepath contains no files, 
# "" is printed to stdout. Otherwise, the full path to one of the
# image files is printed to stdout.
BEGIN {
    # Set the path for commands
    IMAGEPATH = ARGV[1]
    
    numimages = 0
    listImagesCmd = "ls -1 " IMAGEPATH
    while ( listImagesCmd | getline ) {
        images[numimages++] = $0
    }
    close(listImagesCmd)

    if ( numimages > 0 ) {
        # Randomly pick an image to display
        cmd = "/bin/bash -c 'echo $RANDOM'"
        cmd | getline seed
        close(cmd)
        srand(seed)
        i = int(rand() * numimages)
        image = IMAGEPATH "/" images[i]
    }
    else {
        image = ""
    }
    print image
}
