#!/bin/bash
#
# Various logging methods. All output is sent to stderr, which the
# caller can then redirect.
fn_logger_logerr() {
    local commandAndMethod="$1"
    local message="$2"
    local exception="$3"
    message="$(date) ERROR ${commandAndMethod} - ${message}"
    if [[ ! -z "${exception}" ]]
    then
        message+="; Exception: ${exception}"
    fi
    echo "${message}" >&2
}

fn_logger_loginfo() {
    local commandAndMethod=$1
    local info=$2
    echo "$(date) INFO ${commandAndMethod}: ${info}" >&2
}

fn_logger_logwarning() {
    local commandAndMethod=$1
    local warning=$2
    echo "$(date) WARNING ${commandAndMethod}: ${warning}" >&2
}
