#!/bin/bash
# Invoke this script to initialize our utilities.

IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT="${CMDPATH}"

UPSTART="${INSTALLROOT}/upstartScripts"

"${INSTALLROOT}"/configure.sh
mount -o remount,rw /

if [[ $(grep -c "Kindle AutoX Screen Saver:" /etc/crontab/root) -eq 0 ]]
then
    cat crontab.txt | sed -e "s;/mnt/us/kindleautox;${INSTALLROOT};g" >> /etc/crontab/root
    "${INSTALLROOT}/bin/restartcron.sh"
fi

upstartScripts="kindleautox_onstart.conf kindleautox_processevents.conf"
for script in ${upstartScripts}
do
    if [[ ! -f "/etc/upstart/${script}" ]]
    then
        cat "${UPSTART}/${script}" | sed -e "s;/mnt/us/kindleautox;${INSTALLROOT};g" > "/etc/upstart/${script}"
        chmod 644 "/etc/upstart/${script}"
    fi
done

# The following may fail. The lab126 support invokes something that
# keeps / open such that remounting / as read-only fails.
mount -o remount,ro / 2>/dev/null
