#!/bin/bash
IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD=$(basename "$0")
CMDPATH=$(dirname "$0")
if [[ "${CMDPATH}" == "" ]]; then CMDPATH="./"; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")

source "${INSTALLROOT}/config/config.sh"
source "${INSTALLROOT}/lib/sh/fn_logger.sh"
config="${INSTALLROOT}/config/homeauto.json"

# busybox bash does not support arrays.
# Therefore, we mimic them using regular variables.
#declare -A configdict    # NOT SUPPORTED

if [[ ! -f "$config" ]]; then
    fn_logger_logerr "$CMD" "Could not read configuration, file = $config." "File not found"
    exit 1
fi

# Read the JSON configuration file
#
# We don't use a pipe to send the output from ${JQ}
# to the while loop because don't want the while loop
# running as a child process. We need the variables
# set within the while loop avaiable outside.
#
# The kindle's busybox version of bash(1) does not support
# associative arrays. Nor does it support Process Substitution
# notation such as:
#
# while read i; do echo $i; done < <("${JQ}" ...)
#
# The above would generate the following syntax error:
#
# syntax error: unexpected redirection
#
# So we have to use a temporary file to hold the output
# from ${JQ} instead.
tmpfile="/tmp/homeauto$$"
trap "trap '' EXIT SIGINT SIGTERM; rm -f \"${tmpfile}\"" EXIT SIGINT SIGTERM
"${JQ}" -r 'to_entries | .[] | "\(.key):\(.value)"' "${config}" > "${tmpfile}"
while IFS=":," read -r key value
do
    key=$(echo "${key}" | tr -d ' "')
    value=$(echo "${value}" | tr -d ' "')

    #config_dict["${key}"]="${value}"       # NOT SUPPORTED
    eval "${key}=\"${value}\""
done < "${tmpfile}"

#dirigeraIP="${configdict[dirigeraIP]}"    # NOT SUPPORTED
if [[ -z "$dirigeraIP" ]]; then
    fn_logger_logerr "$CMD" "Configuration missing 'dirigeraIP' definition, file = $config." ""
    exit 1
fi

#accessToken="${configdict[accessToken]}"    # NOT SUPPORTED
if [[ -z "${accessToken}" ]]; then
    fn_logger_logerr "$CMD" "Configuration missing 'accessToken' definition, file = $config." ""
    exit 1
fi

devicesURL="https://${dirigeraIP}:8443/v1/devices"
response=$(curl -s -k -H "Authorization: Bearer ${accessToken}" "${devicesURL}")

# Print the JSON response in a formatted way
echo "${response}" | eval ${JQ} .
