#!/bin/bash

IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT="${CMDPATH}"

CONFIG="${INSTALLROOT}/config/config.sh"
if [[ -f "${CONFIG}" ]]
then
    printf "${CONFIG} exists. Overwrite (y/n)? "
    response=$(line | awk '{ gsub(/^\s+|\s+$/, "", $0); print tolower($0) }')
    if [[ "${response}" != 'y' && "${response}" != 'yes' ]]
    then
        exit
    fi
fi

if [[ -f "/usr/bin/mplay" ]]
then
    # We are on a newer kindle and aplay won't work.
    PLAYER="/usr/bin/mplay"
elif [[ -f "/usr/bin/aplay" ]]
then
    PLAYER="/usr/bin/aplay"
else
    PLAYER=""
fi

JQ=$(type jq 2>&1)
JQ="${JQ##* }"    # Get the last field which equal either a path the word "found".
if [[ "${JQ}" == "found" ]]
then
    if [[ "$(grep -c "model name.*ARMv7" /proc/cpuinfo)" -gt 0 ]]
    then
        JQ='${INSTALLROOT}/bin/jq-linux-armhf'
    else
        JQ=""
    fi
fi

EIPS=$(type eips_v2 2>&1)
EIPS="${EIPS##* }"    # Get the last field which equal either a path the word "found"
if [[ "${EIPS}" == "found" ]]
then
    HASEIPS_V2=false
    EIPS=$(type eips 2>&1)
    EIPS="${EIPS##* }"    # # Get the last field which equal either a path the word "found"
    if [[ "${EIPS}" == "found" ]]
    then
        EIPS=""
    fi
else
    HASEIPS_V2=true
fi

FBINK=""
# The version of fbink provided by MR Installer has an issue
# with it in that it doesn't know about the Kindle Signature
# 12th Edition and fails with the following error:
if [[ -f /mnt/us/extensions/MRInstaller/bin/KHF/fbink ]]
then
    FBINK=/mnt/us/extensions/MRInstaller/bin/KHF/fbink
elif [[ -f /mnt/us/extensions/MRInstaller/bin/K5/fbink ]]
then
    FBINK=/mnt/us/extensions/MRInstaller/bin/K5/fbink
elif [[ -f /mnt/us/extensions/MRInstaller/bin/K3/fbink ]]
then
    FBINK=/mnt/us/extensions/MRInstaller/bin/K3/fbink
elif [[ -f /mnt/us/extensions/MRInstaller/bin/PW2/fbink ]]
then
    FBINK=/mnt/us/extensions/MRInstaller/bin/PW2/fbink
else
    FBINK=""
fi

cat > "${CONFIG}" <<!
#!/bin/bash
#
# This file is generated automatically. Please do not edit.
DEBUG=0
INSTALLROOT="${INSTALLROOT}"
LOGDIR="\${INSTALLROOT}/log"
PLAYER="${PLAYER}"
JQ="${JQ}"
HASEIPS_V2="${HASEIPS_V2}"
EIPS="${EIPS}"
FBINK="${FBINK}"

# If the device's battery level goes below the value below we
# will allow the device to suspend. Otherwise, we will
# delay any suspend requests if the screen saver is
# visible. The device is not always in a charging state
# even when plugged in, so we cannot rely on the charging
# state alone to know whether to keep the device from
# suspending.
#
# This threshold also applies to such activities as keeping the
# bluetooth connection alive. If the device is not charing and
# the batter level falls below this threshold, we won't maintain
# a bluetooth connection.
#
# The following events are generated when plugging in and unplugging the
# kindle from a power source. Notice that there is no event that is unique
# to plugging the device into a power source.
#
# There is, however, a "usbdisconnected" event that indicates when the
# device is disconnected from a power source. Unfortunately, there is
# no corresponding "usbconnected" event.
#
# When connecting to a power source:
# com.lab126.powerd battStateInfoChanged "{"battInfo":[{"type":"PRIMARY","cap":99,"charging":true}],"state":"STANDALONE_USB","aggr_batt":99,"usb":true}"
# com.lab126.powerd charging
#
# When disconnecting to a power source:
# com.lab126.powerd battStateInfoChanged "{"battInfo":[{"type":"PRIMARY","cap":99,"charging":false}],"state":"STANDALONE","aggr_batt":99,"usb":false}"
# com.lab126.powerd notCharging
# com.lab126.powerd usbdisconnected
#
# When the kindle's battery level reaches 100% while connected
# to a power source and the kindle stops charging, it
# dispatches the following events:
#
# com.lab126.powerd battStateInfoChanged "{"battInfo":[{"type":"PRIMARY","cap":100,"charging":false}],"state":"STANDALONE","aggr_batt":100,"usb":false}"
# com.lab126.powerd notCharging
# com.lab126.powerd usbdisconnected
# com.lab126.powerd battStateInfoChanged "{"battInfo":[{"type":"PRIMARY","cap":100,"charging":false}],"state":"STANDALONE","aggr_batt":100,"usb":false}"
# com.lab126.powerd charging
# com.lab126.powerd battStateInfoChanged "{"battInfo":[{"type":"PRIMARY","cap":100,"charging":false}],"state":"STANDALONE","aggr_batt":100,"usb":false}"
# com.lab126.powerd notCharging
#
# Notice that the "charging" and "usb" members of the battInfo JSON
# are always the same value (true when charging and false when not).
#
# Therefore, We must rely on both the charging state and battery level
# to know whether to allow the device to suspend. See bin/shLib/fn_kindle,
# specifically the fn_kindle_keepalive function, for more details.
#
# We have seen the Kindle Signature 12th Gen go as low as 95% capcity
# before charging started again, and in some cases will discharge
# to 50%.
BATTLEVELTHRESHOLD=90

# We use the following to decrease the number of readyToSuspend events
# that we see when the screensaver is visible. See the readyToSuspend
# event processing in bin/processeventsloop.sh for details. We do not
# want this value too large because the kindle might not be plugged
# in and we are depending on the battery level and ${BATTLEVELTHRESHOLD}
# above to keep the kindle from suspending. We don't want the battery
# level getting too low without seeing another suspend request.
DEFERSUSPENDINSECS=600    # (in seconds - 10 minutes)
!
