#!/bin/bash
#
# See the following file for the MAC address and
# name to use when connecting bluetooth devices.
# This file lists all the devices that are known
# and previously connected.
#
# /var/local/zbluetooth/bt_devices.xml (pre 5.17.1 versions) or
# /var/local/zbluetooth/bt_config.conf (5.17.1 and above)
#
#
# For bt_devices.xml:
# Look at each device's <device ...> XML object definition,
# specifically the <bd_addr> XML member for the MAC address and
# <device_name> member for the name.
#
# Example:
#
# <X_BROADCOM_COM_BluetoothAdapter>
#   <bt_devices>
#     <device value = "0">
#       <bd_addr>49:41:7E:DB:AD:F3:</bd_addr>
#       <device_name>EWA Audio A106Pro</device_name>
#       <class_of_device>24:04:04:</class_of_device>
#       ...
#
#
# For bt_config.config:
# Look at each device's definition, specifically the first
# line of each device definition for the MAC address and
# the "Name" member for the name.
#
# Example:
#
# [49:41:7e:db:ad:f3]
# Timestamp = 1745019543
# Name = EWA Audio A106Pro
# DevClass = 2360324
# DevType = 1
# AddrType = 0
# Manufacturer = 0
# LmpVer = 0
# LmpSubVer = 0
# LinkKeyType = 4
# PinLength = 0
# LinkKey = f325a97f6c37c9baef86f828c40a8f85
# Service = 0000111e-0000-1000-8000-00805f9b34fb 0000110b-0000-1000-8000-00805f9b3
# AvdtpVersion = 259
#
#BTDEVICE_ADDR="2c:71:ff:e2:d9:cd" # echo
#BTDEVICE_NAME="Echo Dot-0A0"

BTDEVICE_ADDR="49:41:7e:db:ad:f3"  # small speaker
BTDEVICE_NAME="EWA Audio A106Pro"
