#!/bin/bash
#
# Main kindle event processing script used to:
#
# 1) Keep the kindle from suspending (entering a deep sleep) when
#    plugged into a power source.
#
# 2) Support screensaver/show.sh and screensaver/showtime.sh
#    displaying screen saver images and the current date/time.
#
# 3) Keep any Bluetooth device connected as long as the kindle is
#    plugged in.
#
# Most logic appears in ${INSTALLROOT}/bin/processeventsloop.sh.
# See this script for more details.

IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")
LOGFILE="${INSTALLROOT}/log/processevents"

source "${INSTALLROOT}/lib/sh/fn_logger.sh"

fn_exitactions() {
    # Without the following, the lipc-wait-event invocations might not be
    # terminated and end up being inherited by init.
    kill 0
}

fn_onexit() {
    # Ignore these now so we don't get invoked again on multiple interrupts.
    trap "" EXIT SIGINT SIGTERM
    fn_exitactions
    if [[ "${DEBUG}" == 1 ]]; then fn_logger_loginfo "${CMD}" "exiting" 2>>"${LOGFILE}"; fi
    exit 0
}

# Trap requires a semicoln after the the last command.
trap "{ fn_onexit; }" EXIT

# We had to invoke two lipc-wait-event commands below, one to manage
# standard kindle events and another to handle our custom events,
# piping the output from both to our event processing loop, because
# there is a limit to the number of event names that lipc-wait-event
# can handle. What I found was that if you attempt to use a single
# invocation, it ends up never receiving/processing the events
# towards the end of the event name list.
(
    printf 'com.lab126.powerd\ncom.lab126.btfd\n' |\
    lipc-wait-event -l -m "usbdisconnected,charging,battStateInfoChanged,goingToScreenSaver,outOfScreenSaver,readyToSuspend,suspending,Disconnect_Result" &

    printf 'com.kindleautox.gen\n' |\
    lipc-wait-event -l -m "readcfg,stop" &

    printf 'com.kindleautox.media\n' |\
    lipc-wait-event -l -m "safetoplay,play,playwhenpluggedinandinscreensavermode,stop,playingmedia,playingcomplete" &

    printf 'com.kindleautox.screensaver\n' |\
    lipc-wait-event -l -m "showtime,showtimecomplete,showimage,showimagecomplete" &
) |\
${INSTALLROOT}/bin/processeventsloop.sh
