#!/bin/bash
#
# Dipsplay a random screen saver image and the current date/time in
# digital form at the top. Calls showtime.sh to display the date/time.
IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")
SOUNDPATH="${INSTALLROOT}/sounds/randomquotes"
LOGFILE="${INSTALLROOT}/log/playrandomquote"

source "${INSTALLROOT}/config/config.sh"
source "${INSTALLROOT}/lib/sh/fn_logger.sh"

file=$(${INSTALLROOT}/bin/getrandomfile.awk "${SOUNDPATH}")
if [[ ! -z "${file}" ]]
then
    "${INSTALLROOT}/bin/playmediawhenpluggedinandinscreensavermode.sh" "${file}"
# else, no sound files exist.
fi

