#!/bin/bash
#
# Play a media file.
#
# usage: playMedia.sh mediafile
#
# where:
#
# mediafile = some media file to play (e.g., a .wav file).
#
IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")
LOGFILE="${INSTALLROOT}/log/playmedia"

source "${INSTALLROOT}/config/config.sh"
source "${INSTALLROOT}/lib/sh/fn_logger.sh"

if [[ $# != 1 ]]
then
    echo "usage: ${CMD} wav_or_mp3_file"
    exit 1
fi

if [[ ! -f "$1" ]]
then
    echo "${CMD}: file does not exist, file = \"$1\""
    exit 1
fi
mediafile=$(realpath "$1")
lipc-send-event com.kindleautox.media playwhenpluggedinandinscreensavermode -i $$ -s "$mediafile"

# We do not wait for a "com.kindleautox.media done" event becuase
# we do not know how long the event will play and, therefore,
# do not know what timeout to apply in case processevent.sh
# stops running for some reason. We would not want to timeout
# too soon and we don't want to wait indefinitely.
