#!/usr/bin/awk -f
#
# Identify a random file from a given directory of files.
#
# usage: getrandomfile.awk directory
#
# where:
#
# directory = the path to the directory that contains the files to
# select.
#
# For images, "directory" should contain only .png files. For
# sounds, "directory" should only contain .wav files.
#
# If imagepath contains no files,  "" is printed to stdout.
# Otherwise, the full path to one of the files in the given
# directory is printed to stdout.
BEGIN {
    # Set the path for commands
    FILEPATH = ARGV[1]
    
    numfiles = 0
    lscmd = "ls -1 " FILEPATH
    while ( lscmd | getline ) {
        files[numfiles++] = $0
    }
    close(lscmd)

    if ( numfiles > 0 ) {
        # Randomly pick an image to display
        cmd = "/bin/bash -c 'echo $RANDOM'"
        cmd | getline seed
        close(cmd)
        srand(seed)
        i = int(rand() * numfiles)
        file = FILEPATH "/" files[i]
    }
    else {
        file = ""
    }
    print file
}
