#!/bin/bash
#
# Listen for and display most events generated by a given kindle.
#!/bin/bash
IFS="
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")

source "${INSTALLROOT}/config/config.sh"
source "${INSTALLROOT}/lib/sh/fn_logger.sh"


# Base sources, that may not be included in the directory below.
sources='com.lab126.powerd
com.lab126.btfd
'

cd /usr/share/webkit-1.0/pillow/javascripts
sources="${sources}"$(grep "const .*_SOURCE = \"com\." * | sed -e 's/.*_SOURCE = "\(.*\)".*/\1/')
echo "${sources}" | sort -u | lipc-wait-event -l -m "*" | while read event
do
    source=$(echo "${event}" | cut -d ' ' -f1)
    name=$(echo "${event}" | cut -d ' ' -f2)
    data=$(echo "${event}" | cut -d ' ' -f3-)
    if [[ -z "${data}" ]]; then data='""'; fi   # So our info msgs look ok.

    fn_logger_loginfo "${CMD}" "${source} ${name} ${data}"
done
