#!/bin/bash
#
# We use this script to see if we can remount / as read-only at
# various points in the startup process.
#
# usage: chkrootmt.sh [ cmdname ]
#
# where:
#
# cmdname = a command name from which this script has been
# invoked. Used to provide context should we find that /
# is still mounted as rw. If not provided, the basename of
# this script is used.
IFS=" 	
"
PATH="/bin:/usr/bin:/sbin:/usr/sbin"
CMD="${0##*/}"
CMDPATH="${0%/*}"
if [[ "${CMDPATH}" == "$0" ]]; then CMDPATH="."; fi
CMDPATH=$(realpath "${CMDPATH}")
INSTALLROOT=$(realpath "${CMDPATH}/..")

if [[ $# -eq 0 ]]
then
    CMD=$(basename "$0")
else
    CMD="$1"
fi

source "${INSTALLROOT}/config/config.sh"
source "${INSTALLROOT}/lib/sh/fn_logger.sh"

LOGFILE="${LOGDIR}/chkrootmnt"
if [[ $(mount | grep -c "on / .*(rw,") -eq 1 ]]
then
    fn_logger_loginfo "${CMD}" "/ is mounted rw!" 2>>"${LOGFILE}"
fi

exit 0
