#!/usr/bin/env python

__license__ = 'GPL v3'
__copyright__ = '2023, Thiago Oliveira <thiago.eec@gmail.com>'
__docformat__ = 'restructuredtext en'

# --- Horizontal bars graphic --- #
h_html = """
<!DOCTYPE html>
<html>
    <head>
        <title>Horizontal bars</title>
        <style>
            @keyframes grow {{
                from {{width: 0%;}}
                to {{width: auto%;}}
                }}
            .animation {{
              animation: grow 1s;
            }}
            .box-container {{
                display: flex;
                flex-direction: column;
                padding: 0px;
                justify-content: center;
                align-content: center;
                align-items: center;
                width: 95vw;
            }}
            .box-title {{
                font-weight: 500;
                text-align: center;
                width: 100%;
                padding: 8px 8px;
                font-size: 13px;
                color: {0};
            }}
            .box-geners-stats-container-clean {{
                flex-direction: column;
                width: 90vw;
            }}
            .bar-row-container {{
                display: flex;
                flex-direction: column;
                width: 100%;
            }}
            .gn-bar-label-container {{
                font-size: 16px;
                padding-left: 5px;
                padding-bottom: 5px;
                padding-top: 5px;
                color: {0};
            }}
            .sk-bar-label-horizontal-container {{
                display: flex;
                flex-direction: row;
                flex: 1;
                justify-content: flex-start;
            }}
            .sk-bar-horizontal-container {{
                display: flex;
                flex-direction: row;
                justify-content: flex-end;
                justify-content: center;
                align-content: center;
                align-content: center;
                align-self: center;
            }}
            .sk-bar-horizontal-content {{
                height: 10px;
                border-radius: 5px 5px 5px 5px;
                flex: 1;
                background-color: {1};
            }}
            .sk-label-horizontal-container {{
                font-size: 11px;
                padding-left: 5px;
                display: flex;
                justify-content: center;
                margin: 0;
                padding: 0;
                margin-left: 10px;
            }}
            .sk-label-text {{
                font-weight: bold;
                font-size: 14px;
                color: {0};
            }}
        </style>
    </head>
    <body style="background-color:{2}">
        <div class="box-container">
            <span class="box-title">{3}</span>
            <div class="box-geners-stats-container-clean">
                <!-- Placeholder -->
            </div>
        </div>
    </body>
</html>
"""

h_bar = (
    """
    <div class="bar-row-container">
        <div class="gn-bar-label-container">{0}</div>
        <div class="sk-bar-label-horizontal-container">
            <div class="sk-bar-horizontal-container animation" style="width: {1}%">
                <div class="sk-bar-horizontal-content"/>
            </div>
            <div class="sk-label-horizontal-container">
                <span class="sk-label-text">{2}</span>
            </div>
        </div>
    </div>
    """
    )

# --- Vertical bars graphic --- #
v_html = """
<!DOCTYPE html>
<html>
    <head>
        <title>Vertical bars</title>
        <style type="text/css" title="override_css">
            @keyframes grow {{
                from {{height: 0%;}}
                to {{height: auto%;}}
                }}
            .animation {{
              animation: grow 1s;
            }}
            .box-container {{
                display: flex;
                flex-direction: column;
                padding: 0px;
                justify-content: center;
                align-content: center;
                align-items: center;
                height: 95vh;
            }}
            .box-title {{
                font-weight: 500;
                text-align: center;
                width: 100%;
                padding: 8px 8px;
                font-size: 13px;
                margin-bottom: 10vh;
                color: {0};
            }}
            .box-chart-container {{
                margin: 40px 0 10px 0;
                height: 90vh;
                display: flex;
                flex-direction: row;
            }}
            .sk-bar-label-legend-container {{
                display: flex;
                flex-direction: inherit;
            }}
            .sk-bar-label-container {{
                display: flex;
                flex-direction: column;
                flex: 1;
                justify-content: flex-end;
            }}
            .sk-label-container {{
                font-size: 13px;
                font-weight: 500;
                display: flex;
                justify-content: center;
                margin: -40px 0 0 0;
                padding: 0px;
                color: {0};
            }}
            .sk-bar-container {{
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-content: center;
                align-self: center;
                font-weight: normal;
                color: {0};
            }}
            .sk-bar-content {{
                background-color: {1};
                width: 10px;
                border-radius: 5px 5px 0px 0px;
                flex: 1;
            }}
            .sk-bar-legend-container {{
                display: flex;
                flex-direction: column;
                padding: 0px 2px;
                padding-top: 5px;
            }}
            .sk-legend-text {{
                font-size: 11px;
                font-weight: 500;
                color: {0};
                text-transform: uppercase;
            }}
            a {{
                color: inherit
            }}
            a:hover {{
                color: red;
            }}
            .space {{
                margin: 0 0.5vw 0 0.5vw
            }}
        </style>
    </head>
    <body style="background-color:{2}">
        <div class="box-container">
            <span class="box-title">{3}</span>
            <div class="box-chart-container space">
                <!-- Placeholder -->
            </div>
            </div>
        </div>
    </body>
</html>
"""

v_bar = (
    """
    <div class="sk-bar-label-legend-container">
        <div class="sk-bar-label-container">
            <div class="sk-label-container">
                <span>{0}</span>
            </div>
            <div class="sk-bar-container animation" style="height: {1}%">
                <div class="sk-bar-content"/>
            </div>
        </div>
        <div class="sk-bar-legend-container space">
            <span class="sk-legend-text">{2}</span>
        </div>
    </div>
    """
    )

daily_html = """
  <html>
  <head>
    <style type="text/css" title="override_css">
      a {{
          color: inherit
        }}
      a.arrow {{
          color: inherit;
          text-decoration: none
        }}
      a:hover {{
        color: red;
      }}
      .googleChartTitle {{
        font-size: 0.8em;
        text-align: center;
        position: absolute;
        width: 60%;
        color: {2};
        margin: -1.3em 20% 0 20%;
      }}
    </style>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script type="text/javascript">
      google.charts.load('current', {{'packages':['corechart']}});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {{
        var data = google.visualization.arrayToDataTable({0});

        var options = {{
          pointSize: 2,
          animation: {{
            startup: 'true',
            duration: 1000,
            easing: 'out'
          }},
          backgroundColor: '{1}',
          titleTextStyle: {{
            color: '{2}'
          }},
          chartArea : {{
            height: '70%',
            width: '70%',
            right: '5%',
            left: '12%',
          }},
          hAxis: {{
            title: '{3}',
            titleTextStyle: {{color: '{2}'}},
            textStyle: {{color: '{2}'}}
          }},
          vAxis: {{
            title: '{4}',
            titleTextStyle: {{color: '{2}'}},
            textStyle: {{color: '{2}'}},
            viewWindow: {{
              min: 0
            }}
          }},
          legend: {{position: 'none'}}
        }};

        var chart = new google.visualization.LineChart(document.getElementById('curve_chart'));

        chart.draw(data, options);

        const node = document.createElement('div');
        node.className = 'googleChartTitle';
        node.innerHTML = '{5}';

        // Insert the node inside the chart divs
        curve_chart.childNodes[0].childNodes[0].append(node);
      }}
    </script>
  </head>
  <body style="background-color: {1}">
    <div style="font-size: 1em; color: {2}; text-align: left; margin: 0 0 0 5%">
        <a href="http://reading_goal/previous" class="arrow" title="{6}" style="cursor:pointer">⮜</a>
    </div>
    <div style="font-size: 1em; color: {2}; text-align: right; margin: -1.3em 5% 0 0">
        <a href="http://reading_goal/next" class="arrow" title="{7}" style="cursor:pointer">⮞</a>
    </div>
    <div id="curve_chart" style="width: 100%; height: 93%"></div>
  </body>
</html>
"""

buttons_html = """
    <div style="font-size: 1em; color: (.*?); text-align: left; margin: 0 0 0 5%">
        <a href="http://reading_goal/previous" class="arrow" title="(.*?)" style="cursor:pointer">⮜</a>
    </div>
    <div style="font-size: 1em; color: (.*?); text-align: right; margin: -1.3em 5% 0 0">
        <a href="http://reading_goal/next" class="arrow" title="(.*?)" style="cursor:pointer">⮞</a>
    </div>
"""

jan_buttons_html = """
    <div style="font-size: 1em; color: {2}; text-align: right; margin: 0 5% 0 0">
        <a href="http://reading_goal/next" class="arrow" title="{7}" style="cursor:pointer">⮞</a>
    </div>
"""

dec_buttons_html = """
    <div style="font-size: 1em; color: {2}; text-align: left; margin: 0 0 0 5%">
        <a href="http://reading_goal/previous" class="arrow" title="{6}" style="cursor:pointer">⮜</a>
    </div>
"""
