#!/bin/sh

check_fbink() {
	MACHINE_ARCH="$(uname -m)"
	if [ "${MACHINE_ARCH}" = "armv7l" ] ; then
		if [ -e "/lib/ld-linux-armhf.so.3" ] ; then 
			BINARIES_TC="KHF"
		elif grep -e '^Hardware' /proc/cpuinfo | grep -q -e 'i\.MX[[:space:]]\?[6-7]' ; then
			BINARIES_TC="PW2"
		elif grep -e '^Hardware' /proc/cpuinfo | grep -q -e 'MT8110' ; then
			BINARIES_TC="PW2"
		else
			BINARIES_TC="K5"
		fi
	else
		BINARIES_TC="K3"
	fi
	
	FBINK_BIN="/mnt/us/extensions/MRInstaller/bin/${BINARIES_TC}/fbink"
}


# Block OTA updates
rename_ota_binaries() {
  check_fbink
  if [ -f "$1" ] && [ -f "$2" ]; then
    mntroot rw

    for otabin in "$1" "$2"; do
      mv "$otabin" "$otabin~"
    done

    mntroot ro
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation completed!" "Click == REBOOT == to apply changes" "If you want revert this action, relaunch kual."
  else
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Allow OTA updates
restore_ota_binaries() {
  check_fbink
  if [ ! -f "$1" ] && [ ! -f "$2" ]; then
    mntroot rw

    for otabin in "$1" "$2"; do
      mv "$otabin~" "$otabin"
    done

    mntroot ro
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation completed!" "Click == REBOOT == to apply changes" "If you want revert this action, relaunch kual."
  else
	sleep 3
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Block logging
rename_log_binaries() {
  check_fbink
  if [ ! -L "$1" ] && [ ! -L "$2" ] && [ ! -L "$3" ] && [ ! -L "$4" ]; then
    mntroot rw

    for logbin in "$1" "$2" "$3" "$4"; do
      # Backup and link to /dev/null
      cp "$logbin" "$logbin~"
	  ln -sf /dev/null "$logbin"
    done

    mntroot ro
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation completed!" "Click == REBOOT == to apply changes" "If you want revert this action, relaunch kual."
  else
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Restore logging
restore_log_binaries() {
  check_fbink
  if [ -L "$1" ] && [ -L "$2" ] && [ -L "$3" ] && [ -L "$4" ]; then
    mntroot rw

    for logbin in "$1" "$2" "$3" "$4"; do
      mv "$logbin~" "$logbin"
    done

    mntroot ro
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation completed!" "Click == REBOOT == to apply changes" "If you want revert this action, relaunch kual."
  else
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Stop creating core dump files after stopping kindle UI
create_DISABLE_CORE_DUMP() {
  check_fbink
  if [ ! -f "$1" ]; then
	touch /mnt/us/DISABLE_CORE_DUMP
	sleep 3
	"${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation completed!"
	sleep 5
  fi
}

remove_DISABLE_CORE_DUMP() {
  check_fbink
  if [ -f "$1" ]; then
	rm /mnt/us/DISABLE_CORE_DUMP
	sleep 3
	"${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation completed!"
	sleep 5
  fi
}

# Migrate to BinaryRenamer from renameotabin
migrate_from_renameotabin() {
  check_fbink
  if [ -f "$1" ] && [ -f "$2" ]; then
    mntroot rw

    for otabin in "$1" "$2"; do
      mv "$otabin.bck" "$otabin~"
    done

    mntroot ro
    rm -r /mnt/us/extensions/renameotabin
    sleep 3
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation completed!" "Reboot is not required" "Open BinaryRenamer to see Restore OTA button"
  else
    "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# == REBOOT ==
reboot_option() {
  check_fbink
  "${FBINK_BIN}" -pm -y -5 -F TERMINUS "Rebooting in 5s..."
  sleep 5
  reboot
}

# Main script
case "${1}" in
  "block_ota_updates" )
    rename_ota_binaries /usr/bin/otaupd /usr/bin/otav3
  ;;
  "allow_ota_updates" )
    restore_ota_binaries /usr/bin/otaupd /usr/bin/otav3
  ;;
  "block_logging" )
    rename_log_binaries /usr/sbin/syslog-ng /usr/sbin/loginfo /usr/sbin/tinyrot /usr/bin/showlog
  ;;
  "restore_logging" )
    restore_log_binaries /usr/sbin/syslog-ng /usr/sbin/loginfo /usr/sbin/tinyrot /usr/bin/showlog
  ;;
  "disable_core_dump" )
    create_DISABLE_CORE_DUMP /mnt/us/DISABLE_CORE_DUMP
  ;;
  "allow_core_dump" )
    remove_DISABLE_CORE_DUMP /mnt/us/DISABLE_CORE_DUMP
  ;;
  "migrate_to_binaryrenamer" )
    migrate_from_renameotabin /usr/bin/otaupd.bck /usr/bin/otav3.bck
  ;;
  "reboot_device" )
    reboot_option
  ;;
  * )
    echo "Invalid action (${1})" 2>&1 > /dev/null
  ;;
esac

