#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
Copyright (c) 2021-2023 Leseratte10
This file is part of the ACSM Input Plugin by Leseratte10
ACSM Input Plugin for Calibre / acsm-calibre-plugin

For more information, see: 
https://github.com/Leseratte10/acsm-calibre-plugin
'''

# GUI for the ACSM plugin. 
#

from calibre.customize import InterfaceActionBase        # type: ignore
try: 
    from calibre.customize import PluginInstallationType
except:
    pass

from calibre_plugins.deacsm.__init__ import ACSMInput



#@@CALIBRE_COMPAT_CODE_START@@
import sys, os

# Compatibility code taken from noDRM's DeDRM fork. 
# This fixes the weird import issues with Calibre 2, 
# and it allows me to get rid of a ton of try-except blocks.

if "calibre" in sys.modules:

    # Explicitly allow importing everything ...
    if os.path.dirname(os.path.abspath(__file__)) not in sys.path:
        sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

    # Bugfix for Calibre < 5:
    if sys.version_info[0] == 2:
        from calibre.utils.config import config_dir
        for filename in ["ACSM Input.zip", "DeACSM.zip"]:
            __zip_path = os.path.join(config_dir, "plugins", filename)
            if __zip_path not in sys.path and os.path.exists(__zip_path):
                sys.path.insert(0, __zip_path)

#@@CALIBRE_COMPAT_CODE_END@@

class ACSMInputGUIExtension(InterfaceActionBase):
    name                        = "ACSM Input Plugin GUI Extension"
    description                 = "GUI code for ACSM Input Plugin. This is automatically installed and updated with the ACSM plugin."
    supported_platforms         = ['linux', 'osx', 'windows']
    author                      = "Leseratte10"
    minimum_calibre_version     = (4, 0, 0)

    can_be_disabled = False
    # This plugin will be auto-loaded from the ACSM Input plugin. It doesn't make sense for the user
    # to disable it. If necessary, the menu bar button can be removed through the Calibre settings.

    type = ACSMInput.type
    # Just so that the GUI extension shows up at the same place as the actual ACSM Input plugin.

    try: 
        installation_type = PluginInstallationType.EXTERNAL
        # Mark this as user-installed so it shows up in the plugin list by default. 
    except: 
        # Setting the Installation type doesn't always work on Calibre 4 and below.
        pass

    actual_plugin = "calibre_plugins.deacsm.gui_main:ActualACSMInputGUIExtension"

    def is_customizable(self):
        return False


