#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2025, Comfy.n'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class KoboTouchConfigButton(InterfaceActionBase):
    name = 'KoboTouch Config Button'
    description = 'Quick access to KoboTouch device driver configuration'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Comfy.n'
    version = (1, 0, 0)
    minimum_calibre_version = (8, 0, 0)
    actual_plugin = 'calibre_plugins.kobotouch_config_button.action:KoboTouchConfigButtonAction'

    def is_customizable(self):
        return False

    def initialize(self):
        return super().initialize()
