#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2024'
__copyright__ = '2025, Comfy.n'

from calibre.gui2.actions import InterfaceAction
from calibre.gui2 import open_local_file
from calibre.utils.config import config_dir

class ConfigFolderButtonAction(InterfaceAction):
    name = 'Config Folder Button'
    action_spec = ('Config Folder', None, 'Open Calibre configuration folder', '')
    
    def genesis(self):
        # Set custom icon from plugin zip
        icon = get_icons('images/plugin.png')
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.open_config_dir)
    
    def open_config_dir(self):
        open_local_file(config_dir)
        
        
    