#!/usr/bin/env python
__license__   = 'GPL v3'
__copyright__ = '2025, Comfy.n'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class ConfigFolderButtonPlugin(InterfaceActionBase):
    name = 'Config Folder Button'
    description = 'Add toolbar button to open config folder'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Comfy.n'
    version = (1, 1, 0)
    minimum_calibre_version = (6, 25, 0)
    actual_plugin = 'calibre_plugins.config_folder_button.ui:ConfigFolderButtonAction'