#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

from __future__ import (unicode_literals, division, absolute_import, print_function)


__license__ = 'GPL v3'
__copyright__ = '2012-2025, John Howell <jhowell@acm.org>'


# tweaks that can be set in the calibre configuration to modify the functioning of the plugin

'''
usage:

from calibre.utils.config_base import tweaks
tweaks.get(TWEAK_SKIP_LOGIN, False)
'''

TWEAK_AMAZON_IDENT = 'overdrive_link_amazon_ident'
TWEAK_AVG_LOAN_WEEKS = 'overdrive_link_avg_loan_weeks'
TWEAK_CACHE_MISS_PROBABILITY = 'overdrive_link_cache_miss_probability'
TWEAK_CHECK_ONLY_ENABLED_LIB_AVAIL = 'overdrive_link_check_only_enabled_lib_avail'
TWEAK_DISABLE_CACHE = 'overdrive_link_disable_cache'
TWEAK_DISABLE_KU_CHECK = 'overdrive_link_disable_ku_check'
TWEAK_DISABLE_SSL_VERIFICATION = 'overdrive_link_disable_ssl_verification'
TWEAK_DISPLAY_IF_DISCOVERED_AT = 'overdrive_link_display_if_discovered_at'
TWEAK_IGNORE_LOGIN_FAILURE = 'overdrive_link_ignore_login_failure'
TWEAK_INCREMENTAL_AUTHOR_COUNT = 'overdrive_link_incremental_author_count'
TWEAK_LIBRARY_GROUPS = 'overdrive_link_library_groups'
TWEAK_MAX_BOOK_PANEL_LINKS = 'overdrive_link_max_book_panel_links'
TWEAK_REMOVE_RESERVE_IDS = 'overdrive_link_remove_reserve_ids'
TWEAK_SAVE_ALL_RESPONSES = 'overdrive_link_save_all_responses'
TWEAK_SAVE_RESPONSES_ON_ERROR = 'overdrive_link_save_responses_on_error'
TWEAK_SKIP_LOGIN = 'overdrive_link_skip_login'
TWEAK_WAIT_GROUPS = 'overdrive_link_wait_groups'

ALL_OVERDRIVE_LINK_TWEAKS = [
    TWEAK_AMAZON_IDENT, TWEAK_AVG_LOAN_WEEKS, TWEAK_CACHE_MISS_PROBABILITY, TWEAK_CHECK_ONLY_ENABLED_LIB_AVAIL,
    TWEAK_DISABLE_CACHE, TWEAK_DISABLE_KU_CHECK, TWEAK_DISABLE_SSL_VERIFICATION, TWEAK_DISPLAY_IF_DISCOVERED_AT,
    TWEAK_IGNORE_LOGIN_FAILURE, TWEAK_INCREMENTAL_AUTHOR_COUNT, TWEAK_LIBRARY_GROUPS, TWEAK_MAX_BOOK_PANEL_LINKS,
    TWEAK_REMOVE_RESERVE_IDS, TWEAK_SAVE_ALL_RESPONSES, TWEAK_SAVE_RESPONSES_ON_ERROR, TWEAK_SKIP_LOGIN,
    TWEAK_WAIT_GROUPS,
    ]
