﻿#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

from __future__ import (unicode_literals, division, absolute_import, print_function)

__license__ = 'GPL v3'
__copyright__ = '2012-2025, John Howell <jhowell@acm.org>'


LANGUAGES = [
    '', 'Afrikaans', 'Albanian', 'Amharic', 'Arabic', 'Armenian', 'Catalan', 'Chinese',
    'Croatian', 'Czech', 'Danish', 'Dutch', 'English', 'Esperanto', 'Estonian', 'Faeroese',
    'Finnish', 'French', 'Georgian', 'German', 'Greek', 'Guarani', 'Hebrew', 'Hindi',
    'Hungarian', 'Icelandic', 'Indonesian', 'Irish', 'Italian', 'Japanese', 'Kinyarwanda',
    'Korean', 'Kurdish', 'Latin', 'Macedonian', 'Malayalam', 'Mongolian', 'Norwegian', 'Persian',
    'Polish', 'Portuguese', 'Rhaeto-Romance', 'Romanian', 'Russian', 'Samoan', 'Serbian',
    'Serbo-Croatian', 'Sindhi', 'Slovak', 'Slovenian', 'Somali', 'Spanish', 'Swahili', 'Swedish',
    'Tagalog', 'Tajik', 'Tamil', 'Thai', 'Turkish', 'Turkmen', 'Ukrainian', 'Urdu',
    'Uzbek', 'Vietnamese', 'Welsh', 'Wolof', 'Zulu']


LANGUAGE_CODE = {
    'Abkhazian': 'abk', 'Achinese': 'ace', 'Acoli': 'ach', 'Adangme': 'ada',
    'Adyghe': 'ady', 'Afar': 'aar', 'Afrikaans': 'afr', 'Ainu': 'ain', 'Aleut': 'ale',
    'Amharic': 'amh', 'Angika': 'anp', 'Aragonese': 'arg', 'Arapaho': 'arp', 'Arawak': 'arw',
    'Armenian': 'arm', 'Assamese': 'asm', 'Asturian': 'ast', 'Avaric': 'ava',
    'Awadhi': 'awa', 'Balinese': 'ban', 'Bambara': 'bam', 'Basa': 'bas', 'Bashkir': 'bak',
    'Basque': 'baq', 'Beja': 'bej', 'Belarusian': 'bel', 'Bemba': 'bem', 'Bengali': 'ben',
    'Bhojpuri': 'bho', 'Bilin': 'byn', 'Bini': 'bin', 'Bislama': 'bis', 'Bosnian': 'bos',
    'Braj': 'bra', 'Breton': 'bre', 'Buginese': 'bug', 'Bulgarian': 'bul', 'Burmese': 'bur',
    'Caddo': 'cad', 'Catalan': 'cat', 'Cebuano': 'ceb', 'Central Khmer': 'khm', 'Chamorro': 'cha',
    'Chechen': 'che', 'Cherokee': 'chr', 'Cheyenne': 'chy', 'Chinook jargon': 'chn',
    'Chipewyan': 'chp', 'Choctaw': 'cho', 'Chuukese': 'chk', 'Chuvash': 'chv', 'Cornish': 'cor',
    'Corsican': 'cos', 'Creek': 'mus', 'Crimean Tatar': 'crh', 'Croatian': 'hrv',
    'Czech': 'cze', 'Dakota': 'dak', 'Danish': 'dan', 'Dargwa': 'dar', 'Dhivehi': 'div',
    'Dogrib': 'dgr', 'Duala': 'dua', 'Dutch': 'dut', 'Dyula': 'dyu', 'Dzongkha': 'dzo',
    'Eastern Frisian': 'frs', 'Efik': 'efi', 'Ekajuk': 'eka', 'English': 'eng', 'Erzya': 'myv',
    'Ewe': 'ewe', 'Ewondo': 'ewo', 'Fang': 'fan', 'Fanti': 'fat', 'Faroese': 'fao',
    'Fijian': 'fij', 'Filipino': 'fil', 'Finnish': 'fin', 'Fon': 'fon', 'French': 'fre',
    'Friulian': 'fur', 'Ga': 'gaa', 'Galibi Carib': 'car', 'Galician': 'glg', 'Ganda': 'lug',
    'Gayo': 'gay', 'Georgian': 'geo', 'German': 'ger', 'Gilbertese': 'gil', 'Gorontalo': 'gor',
    'Gujarati': 'guj', "Gwich'in": 'gwi', 'Haitian': 'hat', 'Hausa': 'hau',
    'Hawaiian': 'haw', 'Hebrew': 'heb', 'Herero': 'her', 'Hiligaynon': 'hil', 'Hindi': 'hin',
    'Hiri Motu': 'hmo', 'Hungarian': 'hun', 'Hupa': 'hup', 'Iban': 'iba',
    'Icelandic': 'ice', 'Igbo': 'ibo', 'Iloko': 'ilo', 'Inari Sami': 'smn', 'Indonesian': 'ind',
    'Ingush': 'inh', 'Irish': 'gle', 'Italian': 'ita', 'Japanese': 'jpn',
    'Javanese': 'jav', 'Judeo-Persian': 'jpr', 'Kabardian': 'kbd', 'Kabyle': 'kab',
    'Kachin': 'kac', 'Kalaallisut': 'kal', 'Kalmyk': 'xal', 'Kamba (Kenya)': 'kam',
    'Kannada': 'kan', 'Karachay-Balkar': 'krc', 'Kara-Kalpak': 'kaa', 'Karelian': 'krl',
    'Kashmiri': 'kas', 'Kashubian': 'csb', 'Kazakh': 'kaz', 'Khasi': 'kha', 'Kikuyu': 'kik',
    'Kimbundu': 'kmb', 'Kinyarwanda': 'kin', 'Kirghiz': 'kir', 'Korean': 'kor',
    'Kosraean': 'kos', 'Kuanyama': 'kua', 'Kumyk': 'kum', 'Kurukh': 'kru', 'Kutenai': 'kut',
    'Ladino': 'lad', 'Lamba': 'lam', 'Lao': 'lao', 'Lezghian': 'lez', 'Limburgan': 'lim',
    'Lingala': 'lin', 'Lithuanian': 'lit', 'Low German': 'nds', 'Lower Sorbian': 'dsb',
    'Lozi': 'loz', 'Luba-Katanga': 'lub', 'Luba-Lulua': 'lua', 'Luiseno': 'lui',
    'Lule Sami': 'smj', 'Lunda': 'lun', 'Luo': 'luo', 'Lushai': 'lus', 'Luxembourgish': 'ltz',
    'Macedonian': 'mac', 'Macedo-Romanian': 'rup', 'Madurese': 'mad', 'Magahi': 'mag',
    'Maithili': 'mai', 'Makasar': 'mak', 'Malayalam': 'mal', 'Maltese': 'mlt', 'Manchu': 'mnc',
    'Mandar': 'mdr', 'Manipuri': 'mni', 'Manx': 'glv', 'Maori': 'mao', 'Mapudungun': 'arn',
    'Marathi': 'mar', 'Marshallese': 'mah', 'Masai': 'mas', 'Mende': 'men',
    "Mi'kmaq": 'mic', 'Minangkabau': 'min', 'Mirandese': 'mwl', 'Greek': 'gre',
    'Mohawk': 'moh', 'Moksha': 'mdf', 'Mongo': 'lol', 'Mossi': 'mos', 'Nauru': 'nau',
    'Navajo': 'nav', 'Ndonga': 'ndo', 'Neapolitan': 'nap', 'Newari': 'new', 'Nias': 'nia',
    'Niuean': 'niu', "N'Ko": 'nqo', 'Nogai': 'nog', 'North Ndebele': 'nde',
    'Northern Frisian': 'frr', 'Northern Sami': 'sme', 'Norwegian Bokmål': 'nob',
    'Norwegian Nynorsk': 'nno', 'Nyamwezi': 'nym', 'Nyanja': 'nya', 'Nyankole': 'nyn',
    'Nyoro': 'nyo', 'Nzima': 'nzi', 'Occitan': 'oci', 'Osage': 'osa', 'Ossetian': 'oss',
    'Palauan': 'pau', 'Pampanga': 'pam', 'Pangasinan': 'pag', 'Panjabi': 'pan',
    'Papiamento': 'pap', 'Pedi': 'nso', 'Pohnpeian': 'pon', 'Polish': 'pol',
    'Portuguese': 'por', 'Rapanui': 'rap', 'Rarotongan': 'rar', 'Romanian': 'rum', 'Romansh': 'roh',
    'Rundi': 'run', 'Russian': 'rus', 'Samoan': 'smo', 'Sandawe': 'sad', 'Sango': 'sag',
    'Santali': 'sat', 'Sasak': 'sas', 'Scots': 'sco', 'Scottish Gaelic': 'gla',
    'Selkup': 'sel', 'Serbian': 'srp', 'Serer': 'srr', 'Shan': 'shn', 'Shona': 'sna',
    'Sichuan Yi': 'iii', 'Sicilian': 'scn', 'Sidamo': 'sid', 'Siksika': 'bla',
    'Sindhi': 'snd', 'Sinhala': 'sin', 'Skolt Sami': 'sms', 'Slovak': 'slo',
    'Slovenian': 'slv', 'Somali': 'som', 'Soninke': 'snk', 'South Ndebele': 'nbl',
    'Southern Altai': 'alt', 'Southern Sami': 'sma', 'Southern Sotho': 'sot', 'Spanish': 'spa',
    'Sranan Tongo': 'srn', 'Sukuma': 'suk', 'Sundanese': 'sun', 'Susu': 'sus',
    'Swati': 'ssw', 'Swedish': 'swe', 'Swiss German': 'gsw', 'Tagalog': 'tgl',
    'Tahitian': 'tah', 'Tajik': 'tgk', 'Tamil': 'tam', 'Tatar': 'tat', 'Telugu': 'tel',
    'Tereno': 'ter', 'Tetum': 'tet', 'Thai': 'tha', 'Tibetan': 'tib', 'Tigre': 'tig',
    'Tigrinya': 'tir', 'Timne': 'tem', 'Tiv': 'tiv', 'Tlingit': 'tli', 'Tok Pisin': 'tpi',
    'Tokelau': 'tkl', 'Tonga (Nyasa)': 'tog', 'Tonga (Tonga Islands)': 'ton',
    'Tsimshian': 'tsi', 'Tsonga': 'tso', 'Tswana': 'tsn', 'Tumbuka': 'tum', 'Turkish': 'tur',
    'Turkmen': 'tuk', 'Tuvalu': 'tvl', 'Tuvinian': 'tyv', 'Twi': 'twi', 'Udmurt': 'udm',
    'Uighur': 'uig', 'Ukrainian': 'ukr', 'Umbundu': 'umb', 'Upper Sorbian': 'hsb',
    'Urdu': 'urd', 'Vai': 'vai', 'Venda': 'ven', 'Vietnamese': 'vie', 'Votic': 'vot',
    'Walloon': 'wln', 'Waray': 'war', 'Washo': 'was', 'Welsh': 'wel', 'Western Frisian': 'fry',
    'Wolaytta': 'wal', 'Wolof': 'wol', 'Xhosa': 'xho', 'Yakut': 'sah', 'Yao': 'yao',
    'Yapese': 'yap', 'Yoruba': 'yor', 'Zenaga': 'zen', 'Zulu': 'zul', 'Zuni': 'zun'}


LANGUAGE_NAME = {}
for name, code in LANGUAGE_CODE.items():
    LANGUAGE_NAME[code] = name

LANGUAGE_NAME_LOWER = {}
for name in LANGUAGE_CODE.keys():
    LANGUAGE_NAME_LOWER[name.lower()] = name

ALL_LANGUAGE_NAMES = set(LANGUAGE_CODE.keys())


LANGUAGE_CODE2 = {
    '': '', 'Afrikaans': 'af', 'Albanian': 'sq', 'Amharic': 'am', 'Arabic': 'ar',
    'Armenian': 'hy', 'Bulgarian': 'bg', 'Bengali': 'bg',
    'Catalan': 'ca', 'Chinese': 'zh', 'Croatian': 'hr', 'Czech': 'cs',
    'Danish': 'da', 'Dutch': 'nl', 'English': 'en', 'Esperanto': 'eo', 'Estonian': 'et',
    'Faeroese': 'fo', 'Finnish': 'fi', 'French': 'fr', 'Georgian': 'ka', 'German': 'de',
    'Greek': 'el', 'Guarani': 'gn', 'Hebrew': 'he', 'Hindi': 'hi', 'Hungarian': 'hu',
    'Icelandic': 'is', 'Indonesian': 'id', 'Irish': 'ga', 'Italian': 'it', 'Japanese': 'ja ',
    'Kazakh': 'kk', 'Kinyarwanda': 'rw', 'Korean': 'ko', 'Kurdish': 'ku', 'Latin': 'la',
    'Macedonian': 'mk', 'Malayalam': 'ml', 'Marathi': 'mr', 'Mongolian': 'mn',
    'Norwegian': 'no', 'Pashto': 'ps', 'Persian': 'fa', 'Polish': 'pl',
    'Portuguese': 'pt', 'Romanian': 'ro', 'Romansh': 'rm', 'Russian': 'ru', 'Samoan': 'sm',
    'Serbian': 'sr', 'Serbo-Croatian': 'sh', 'Sindhi': 'sd', 'Slovak': 'sk', 'Slovenian': 'sl',
    'Somali': 'so', 'Spanish': 'es', 'Swahili': 'sw', 'Swedish': 'sv', 'Tagalog': 'tl',
    'Tajik': 'tg', 'Tamil': 'ta', 'Thai': 'th', 'Turkish': 'tr', 'Turkmen': 'tk', 'Ukrainian': 'uk',
    'Urdu': 'ur', 'Uzbek': 'uz', 'Vietnamese': 'vi', 'Welsh': 'cy', 'Wolof': 'wo', 'Zulu': 'zu'}

LANGUAGE_NAME2 = {}
for name, code in LANGUAGE_CODE2.items():
    LANGUAGE_NAME2[code] = name
