#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import, print_function)


__license__ = 'GPL v3'
__copyright__ = '2012-2025, John Howell <jhowell@acm.org>'


# series that use 'volume' for number within series and have unique titles
# for other series keep volume as part of title
VOLUMES_WITH_UNIQUE_TITLES = {
    'Age of Conan, Hyborian Adventures: Marauders',
    'Chronicles of the Last Emperor of Melniboné',
    'Mission Earth',
    'Shadowmarch',
    'Sister of Darkness: The Nicci Chronicles',
    'The Peptides Analysis, Synthesis, Biology',
    'The Weird Works of Robert E. Howard',
    }


# titles that should not be allowed on their own
INCOMPLETE_TITLES = [
    "Apex Magazine",
    "Fantasy The Best of the Year",
    "Galaxy's Edge Magazine",
    "Insight Guide",
    "Insight Guides",
    "Mister October",
    "Rivers of London",
    "Science Fiction the Best of the Year",
    "Terry Carr's Best Science Fiction and Fantasy of the Year",
    "The Best From Fantasy and Science Fiction",
    "The Best Horror of the Year",
    "The Best Science Fiction and Fantasy of the Year",
    "The Best Science Fiction of the Year",
    "The Collected Stories of Arthur C. Clarke",
    "The Complete Series",
    "The Making of the West",
    "The Year's Best Dark Fantasy & Horror",
    "The Year's Best Science Fiction & Fantasy",
    "The Years Best Fantasy and Horror",
    "The Years Best Science Fiction",
    "Year's Best Fantasy",
    "Year's Best SF",
    "Year's Best Weird Fiction",
    ]


# override incorrect library book data
def fixup_book_data(log, lbook):
    #log.info('check fixup: key=%s authors=%s' % (lbook.book_key, str(lbook.authors)))

    if lbook.book_key == 'c8f86423-b2ae-40f8-bfd8-e2ab30718497@' and tuple(lbook.authors) == ('John Varley',):
        log.info('Fixed: Rolling Thunder (incorrectly attributed to John Varley at OverDrive)')
        lbook.authors = ['Jack Terral']
        return

    if lbook.book_key == '627bd6d5-73f1-4e5f-b88a-cb6e8d46b989@' and tuple(lbook.authors) == ('Dave Barry Ridley Pearson',):
        log.info('Fixed: Author names merged for The Bridge to Never Land at OverDrive')
        lbook.authors = ['Dave Barry', 'Ridley Pearson']
        return

    if lbook.book_key in ['d7f35621-95e2-4ffa-80bc-3052a833caf3@', '1635169@'] and lbook.title == "Year's Best Weird Fiction":
        log.info("Fixed: Year's Best Weird Fiction missing volume 1 at OverDrive")
        lbook.title = "Year's Best Weird Fiction, Volume 1"
        return

    if lbook.book_key == 'bd240752-c8e7-4f8b-8bd9-4270fb78e7a7@' and tuple(lbook.authors) == ('Dave Barry Ridley Pearson',):
        log.info('Fixed: Author names merged for Peter and the Secret of Rundoon at OverDrive')
        lbook.authors = ['Dave Barry', 'Ridley Pearson']
        return

    if lbook.book_key in ['79389361-958b-4892-8c3f-94a3432a42c2@', '2024241@'] and tuple(lbook.authors) == ('Paula Guran',):
        log.info('Fixed: The Year\'s Best Science Fiction & Fantasy, 2014 Edition (incorrectly attributed to Paula Guran at OverDrive)')
        lbook.authors = ['Rich Horton']
        return

    if lbook.book_key in ['7a3366a2-e752-4695-a7de-4a9efa6e3fb1@', '900204@'] and lbook.title == 'A Novel':
        log.info('Fixed: Operation Chaos (incorrect title at OverDrive)')
        lbook.title = 'Operation Chaos'
        return

    if lbook.book_key in ['8b2dcf00-c7ce-44da-bfa5-80f916b7d7c2@', '637870@'] and lbook.title == 'The Mammoth Book of Terror':
        log.info('Fixed: The Mammoth Book of New Terror (incorrect title at OverDrive)')
        lbook.title = 'The Mammoth Book of New Terror'
        return

    if lbook.book_key == '3a4eab79-b912-4901-91fa-377f6ac10b56@' and lbook.title == 'Fierce Reads: Kisses and Curses':
        log.info('Fixed: (Fierce Reads) Kisses and Curses (incorrect title at OverDrive)')
        lbook.title = '(Fierce Reads) Kisses and Curses'
        return

    if lbook.book_key == '234855674@sc/' and lbook.title == 'Gormenghast':
        log.info('Fixed: Gormenghast - A Stage Adaptation (incomplete title at Everand)')
        lbook.title = 'Gormenghast - A Stage Adaptation'
        return

    if lbook.book_key == '262746908@sc/' and lbook.title.startswith('Ringworld:'):
        log.info('Fixed: Ringworld: The Graphic Novel, Part One (adjust title at Everand)')
        lbook.title = 'Ringworld The Graphic Novel, Part One'
        return

    if (lbook.book_key in [
            '252006989@sc/', '233898872@sc/', 'B007EZJKS2@ak/', 'e6e9dd62-8f36-4825-b563-11c3abcdf9b9@']) and (
            lbook.title == 'The Last Unicorn' or lbook.title.startswith('The Last Unicorn (') or
            lbook.title.startswith('The Last Unicorn:')):
        log.info('Fixed: The Last Unicorn Graphic Novel (incomplete title at Everand/Amazon/Hoopla)')
        lbook.title = 'The Last Unicorn, Issues 1-6'
        return

    if lbook.book_key == 'B00HSR4JUU@ak/' and lbook.title == 'Science Fiction: The Year\'s Best (2006 Edition)':
        log.info('Science Fiction, The Best of the Year, 2006 (Edition) (incorrect title and authors at Amazon)')
        lbook.title = 'Science Fiction, The Best of the Year, 2006 (Edition)'
        lbook.authors = [
                'Rich Horton', 'Michael Swanwick', 'Tom Purdom', 'Douglas Lain', 'James Patrick Kelly', 'Joe Haldeman',
                'Susan Palwick', 'Howard Waldrop', 'Wil McCarthy', 'Leah Bobet', 'Robert Reed', 'James Van Pelt',
                'Mary Rosenblum', 'Stephen Leigh', 'Daniel Kaysen', 'Alastair Reynolds']
        return

    if lbook.book_key == 'B00DRELAX2@ak/' and lbook.title == 'Fantasy: The Best of the Year (Fantasy: The Best of ... (Quality))':
        log.info('Science Fiction, The Best of the Year, 2006 (Edition) (incorrect title and authors at Amazon)')
        lbook.title = 'Fantasy, The Best of the Year, 2006 (Edition)'
        lbook.authors = [
                'Rich Horton', 'Theodora Goss', 'Gene Wolfe', 'Eric Schaller', 'Elizabeth Bea', 'Paul Di Filippo',
                'George Saunders', 'Samantha Henderson', 'Gregory Feeley', 'Neil Gaiman', 'Joe Murphy', 'Sonya Taaffe',
                'Marc Laidlaw', 'Pat Cadigan', 'Peter S. Beagle', 'Michael Canfield', 'Richard Parks', 'Steve Rasnic Tem',
                'Holly Phillips', 'Matthew Hughes']
        return

    if lbook.book_key == '229380421@sc/' and tuple(lbook.authors) == ('Danile C. Dennett',):
        log.info('Fixed: Kinds Of Minds: Toward An Understanding Of Consciousness (incorrect author spelling at Everand)')
        lbook.authors = ['Daniel C. Dennett']
        return

    if lbook.book_key == '11461668@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse One (incomplete title at Hoopla)')
        lbook.title = 'Eclipse One: New Science Fiction and Fantasy'
        return

    if lbook.book_key == '11461669@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse Two (incomplete title at Hoopla)')
        lbook.title = 'Eclipse Two: New Science Fiction and Fantasy'
        return

    if lbook.book_key == '11461444@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse Three (incomplete title at Hoopla)')
        lbook.title = 'Eclipse Three: New Science Fiction and Fantasy'
        return

    if lbook.book_key == '11461445@ho/' and lbook.title == 'Eclipse':
        log.info('Fixed: Eclipse Four (incomplete title at Hoopla)')
        lbook.title = 'Eclipse Four: New Science Fiction and Fantasy'
        return

    if lbook.book_key == '296189643@sc/':
        log.info("Fixed: Sora's Quest by T. L. Shreffler (incorrect title and author at Everand)")
        lbook.title = "Sora's Quest"
        lbook.authors = ['T. L. Shreffler']
        return

    if lbook.book_key == '314636376@sc/' and lbook.title == 'The Best Science Fiction of the Year, 2016':
        log.info('Fixed: The Best Science Fiction of the Year, Volume One (adjust title at Everand)')
        lbook.title = 'The Best Science Fiction of the Year, Volume One'
        return

    if lbook.book_key == '922f8d68-a0ab-4cb0-ba39-b4149be37139@' and lbook.title == 'A Novel':
        log.info('Fixed: Steeplejack: A Novel (incorrect title at OverDrive)')
        lbook.title = 'Steeplejack: A Novel'
        return

    if lbook.book_key == '2970388@' and lbook.title == 'Fantastic Beasts and Where to Find Them: The Original Screenplay':
        log.info('Fixed: Fantastic Beasts and Where to Find Them, The Original Screenplay (incomplete title at OverDrive)')
        lbook.title = 'Fantastic Beasts and Where to Find Them, The Original Screenplay'
        return

    if lbook.book_key.startswith('OL2485608W@ol/') and lbook.title == 'Little Myth Marker':
        log.info('Fixed: Myth-Ing Persons (wrong title at Open Library)')
        lbook.title = 'Myth-Ing Persons'
        return

    if lbook.book_key.startswith('OL460023W@ol/') and lbook.title == 'The Unexpected Hanging: And Other Mathematical Diversions.':
        log.info('Fixed: %s by Martin Gardner (wrong book at Open Library)' % lbook.title)
        lbook.title = 'Fire Engines'
        lbook.authors = ['Anne Rockwell']
        return

    if lbook.book_key == 'B072QY1WNG@ak/' and lbook.title == 'Swords Against Darkness':
        log.info('Fixed: Swords Against Darkness, Collection (needs unique title)')
        lbook.title = 'Swords Against Darkness, Collection'
        return

    if lbook.book_key == 'rumuf89@3m/' and lbook.title.startswith('Legión'):
        log.info('Fixed: Legión (Flash Relatos)')
        lbook.title = 'Legión, Flash Relatos'
        return

    if lbook.book_key == 'MDAxMDE5LTQ2MjAwMjg0@fr' and lbook.title == 'Witch World: Estcarp Cycle':
        log.info('Fixed: Witch World: Estcarp Cycle')
        lbook.title = 'Witch World Estcarp Cycle'
        return

    if lbook.book_key == 'MDAxMDE5LTQ2MjAwMzk4@fr' and lbook.title == 'Witch World: High Hallack Cycle':
        log.info('Fixed: Witch World: High Hallack Cycle')
        lbook.title = 'Witch World High Hallack Cycle'
        return

    if lbook.book_key == 'xnftm89@3m/' and lbook.title.startswith('Legión'):
        log.info('Fixed xnftm89@3m: %s' % lbook.title)
        lbook.title = 'Legión, Las múltiples vidas de Stephen Leeds'
        return

    if lbook.book_key == '12451893@ho/' and lbook.title == 'Fearful Symmetries':
        log.info('Fixed: Fearful Symmetries (missing author at Hoopla)')
        lbook.authors = ['Ellen Datlow']
        return

    if lbook.book_key == 'angelcasefiles00hold@ia/' and lbook.title == 'Angel':
        log.info('Fixed angelcasefiles00hold9@3m: %s' % lbook.title)
        lbook.title = 'Angel, The Casefile, Volume 1'
        return

    if lbook.book_key == '14272695@ho/' and lbook.title == 'The Psychology of Consciousness':
        log.info('Fixed 14272695@ho: %s' % lbook.title)
        lbook.title = 'New World New Mind'
        return

    if lbook.book_key == '14994891@ho/' and lbook.title == 'Stroke of Genius':
        log.info('Fixed: Alien Envoy (Wrong title/author at Hoopla)')
        lbook.title = 'Alien Envoy'
        lbook.authors = ['Malcom Jameson']
        return

    if lbook.book_key == '15433433@ho/' and lbook.title == "The Year's Best Dark Fantasy & Horror, 2020":
        log.info('Fixed 15433433@ho: %s' % lbook.title)
        lbook.title = "The Year's Best Dark Fantasy & Horror, 2019"
        return

    if lbook.book_key == '15547084@ho/' and lbook.title == "The Year's Best Science Fiction & Fantasy, 2022":
        log.info('Fixed 15547084@ho: %s' % lbook.title)
        lbook.title = "The Year's Best Science Fiction & Fantasy, 2021"
        return
