local ffi = require("ffi")
ffi.cdef[[
struct z_stream_s {
  unsigned char *next_in;
  unsigned int avail_in;
  long unsigned int total_in;
  unsigned char *next_out;
  unsigned int avail_out;
  long unsigned int total_out;
  char *msg;
  struct internal_state *state;
  void *(*zalloc)(void *, unsigned int, unsigned int);
  void (*zfree)(void *, void *);
  void *opaque;
  int data_type;
  long unsigned int adler;
  long unsigned int reserved;
};
struct rfbClientData {
  void *tag;
  void *data;
  struct rfbClientData *next;
};
typedef struct _rfbClient rfbClient;
typedef signed char rfbBool;
struct _rfbClient {
  unsigned char *frameBuffer;
  int width;
  int height;
  int endianTest;
  struct {
    signed char shareDesktop;
    signed char viewOnly;
    const char *encodingsString;
    signed char useBGR233;
    int nColours;
    signed char forceOwnCmap;
    signed char forceTrueColour;
    int requestedDepth;
    int compressLevel;
    int qualityLevel;
    signed char enableJPEG;
    signed char useRemoteCursor;
    signed char palmVNC;
    int scaleSetting;
  } appData;
  const char *programName;
  char *serverHost;
  int serverPort;
  signed char listenSpecified;
  int listenPort;
  int flashPort;
  struct {
    int x;
    int y;
    int w;
    int h;
  } updateRect;
  char buffer[307200];
  int sock;
  signed char canUseCoRRE;
  signed char canUseHextile;
  char *desktopName;
  struct {
    unsigned char bitsPerPixel;
    unsigned char depth;
    unsigned char bigEndian;
    unsigned char trueColour;
    short unsigned int redMax;
    short unsigned int greenMax;
    short unsigned int blueMax;
    unsigned char redShift;
    unsigned char greenShift;
    unsigned char blueShift;
    unsigned char pad1;
    short unsigned int pad2;
  } format;
  struct {
    short unsigned int framebufferWidth;
    short unsigned int framebufferHeight;
    struct {
      unsigned char bitsPerPixel;
      unsigned char depth;
      unsigned char bigEndian;
      unsigned char trueColour;
      short unsigned int redMax;
      short unsigned int greenMax;
      short unsigned int blueMax;
      unsigned char redShift;
      unsigned char greenShift;
      unsigned char blueShift;
      unsigned char pad1;
      short unsigned int pad2;
    } format;
    unsigned int nameLength;
  } si;
  char buf[8192];
  char *bufoutptr;
  int buffered;
  int ultra_buffer_size;
  char *ultra_buffer;
  int raw_buffer_size;
  char *raw_buffer;
  struct z_stream_s decompStream;
  signed char decompStreamInited;
  char zlib_buffer[30000];
  struct z_stream_s zlibStream[4];
  signed char zlibStreamActive[4];
  signed char cutZeros;
  int rectWidth;
  int rectColors;
  char tightPalette[1024];
  unsigned char tightPrevRow[12288];
  signed char jpegError;
  struct jpeg_source_mgr *jpegSrcManager;
  void *jpegBufferPtr;
  long unsigned int jpegBufferLen;
  unsigned char *rcSource;
  unsigned char *rcMask;
  struct rfbClientData *clientData;
  struct {
    struct _IO_FILE *file;
    struct timeval tv;
    signed char readTimestamp;
    signed char doNotSleep;
  } *vncRec;
  int KeyboardLedStateEnabled;
  int CurrentKeyboardLedState;
  int canHandleNewFBSize;
  void (*HandleTextChat)(struct _rfbClient *, int, char *);
  void (*HandleKeyboardLedState)(struct _rfbClient *, int, int);
  signed char (*HandleCursorPos)(struct _rfbClient *, int, int);
  void (*SoftCursorLockArea)(struct _rfbClient *, int, int, int, int);
  void (*SoftCursorUnlockScreen)(struct _rfbClient *);
  void (*GotFrameBufferUpdate)(struct _rfbClient *, int, int, int, int);
  char *(*GetPassword)(struct _rfbClient *);
  signed char (*MallocFrameBuffer)(struct _rfbClient *);
  void (*GotXCutText)(struct _rfbClient *, const char *, int);
  void (*Bell)(struct _rfbClient *);
  void (*GotCursorShape)(struct _rfbClient *, int, int, int, int, int);
  void (*GotCopyRect)(struct _rfbClient *, int, int, int, int, int, int);
  struct {
    unsigned char client2server[32];
    unsigned char server2client[32];
  } supportedMessages;
  int major;
  int minor;
  unsigned int authScheme;
  unsigned int subAuthScheme;
  void *tlsSession;
  union _rfbCredential *(*GetCredential)(struct _rfbClient *, int);
  unsigned int *clientAuthSchemes;
  char *destHost;
  int destPort;
  int QoS_DSCP;
  void (*HandleXvpMsg)(struct _rfbClient *, unsigned char, unsigned char);
  int listenSock;
  void (*FinishedFrameBufferUpdate)(struct _rfbClient *);
  char *listenAddress;
  int listen6Sock;
  char *listen6Address;
  int listen6Port;
  long unsigned int outputWindow;
};
struct _rfbClient *rfbGetClient(int, int, int);
signed char rfbInitClient(struct _rfbClient *, int *, char **);
extern void (*rfbClientLog)(const char *, ...);
signed char SendKeyEvent(struct _rfbClient *, unsigned int, signed char);
signed char SendPointerEvent(struct _rfbClient *, int, int, int);
signed char SendFramebufferUpdateRequest(struct _rfbClient *, int, int, int, int, signed char);
signed char SendIncrementalFramebufferUpdateRequest(struct _rfbClient *);
signed char SendScaleSetting(struct _rfbClient *, int);
signed char SetFormatAndEncodings(struct _rfbClient *);
void rfbClientCleanup(struct _rfbClient *);
signed char HandleRFBServerMessage(struct _rfbClient *);
]]
