#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2020, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt)

from calibre import prints
from calibre.constants import DEBUG

from calibre_plugins.action_chains.events.base import ChainEvent

try:
    load_translations()
except NameError:
    prints("ActionChains::events/location_selected.py - exception when loading translations")

class LocationSelectedEvent(ChainEvent):

    name = 'Location Selected'
    
    def get_event_signal(self):
        return self.plugin_action.plugin_location_selected
