#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, pyqtSignal)

from calibre import prints
from calibre.constants import DEBUG
from calibre.utils.config import tweaks

from calibre_plugins.action_chains.events.base import ChainEvent
try:
    load_translations()
except NameError:
    prints("ActionChains::events/library_about_to_change.py - exception when loading translations")

class LibraryAboutToChangeEvent(ChainEvent):

    name = 'Library About To Change'

    library_about_to_change = pyqtSignal(str, str)

    def __init__(self, plugin_action):
        ChainEvent.__init__(self, plugin_action)
        self.plugin_action.plugin_library_about_to_change.connect(self._on_library_about_to_change)

    def _on_library_about_to_change(self, olddb, db):
        if olddb and db:
            self.library_about_to_change.emit(olddb.library_path, db.library_path)
    
    def get_event_signal(self):
        return self.library_about_to_change

