#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2021, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import os
import copy
import time

from calibre_plugins.action_chains.scopes.fallback import FallbackScope

from calibre import prints
from calibre.constants import DEBUG


try:
    load_translations()
except NameError:
    prints("ActionChains::scopes/scope_tools.py - exception when loading translations")

class ScopeWrapper(object):

    def __init__(self, plugin_action, scope_config, chain):
        self.plugin_action = plugin_action
        self.gui = plugin_action.gui
        self.db = self.gui.current_db
        # copy as to not overwrite mutable data
        self.scope_config = copy.deepcopy(scope_config)
        scope_manager_name = scope_config.get('scope_manager_name', FallbackScope.name)
        self.scope_manager = self.plugin_action.scopes[scope_manager_name]
        self.scope_settings = scope_config.get('scope_manager_settings', {})
        self.chain = chain

    def get_book_ids(self):
        return self.scope_manager.get_book_ids(self.gui, self.scope_settings, self.chain)

    def get_current_book_id(self):
        return self.scope_manager.get_current_book_id(self.gui, self.scope_settings, self.chain)

def validate_scope(plugin_action, chain_link):
    msg = _('Scope errors')
    scope_config = chain_link.get('scope_settings')
    if not scope_config:
        return True
    scope_manager_name = scope_config['scope_manager_name']
    if not scope_manager_name in plugin_action.scopes.keys():
        details = _(f'Scope ({scope_manager_name}) is not available')
        return msg, details
    scope_manager = plugin_action.scopes[scope_manager_name]
    is_scope_valid = scope_manager.validate(scope_config.get('scope_manager_settings', {}))
    return is_scope_valid
