#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2020, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, pyqtSignal, QTimer)

from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2.device import device_signals

from calibre_plugins.action_chains.events.base import ChainEvent

try:
    load_translations()
except NameError:
    prints("ActionChains::events/device_disconnected.py - exception when loading translations")

class DeviceDisconnectedEvent(ChainEvent):

    name = 'Device Disconnected'

    device_disconnected = pyqtSignal()

    def __init__(self, plugin_action):
        ChainEvent.__init__(self, plugin_action)
        device_signals.device_connection_changed.connect(self._on_device_connection_changed)

    def _on_device_connection_changed(self, is_connected):
        if not is_connected:
            # Use QTimer to defeter this signal untill all other slots connected to
            # device_signals.device_connection_changed are called
            QTimer.singleShot(0, self.device_disconnected.emit)
    
    def get_event_signal(self):
        return self.device_disconnected
