#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2020, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, QAbstractItemView, pyqtSignal)

from calibre import prints
from calibre.constants import DEBUG
from calibre.utils.config import tweaks

from calibre_plugins.action_chains.events.base import ChainEvent
from calibre_plugins.action_chains.events.event_tools import EventLoop

try:
    load_translations()
except NameError:
    prints("ActionChains::events/book_list_enter_key_pressed.py - exception when loading translations")

class BookListEnterKeyPressedEvent(ChainEvent):

    name = 'Book List Enter Key Pressed'

    book_list_enter_key_pressed = pyqtSignal(int, str)

    def __init__(self, plugin_action):
        ChainEvent.__init__(self, plugin_action)
        self.plugin_action.gui.enter_key_pressed_in_book_list.connect(self._on_book_list_enter_key_pressed)

    def _on_book_list_enter_key_pressed(self, *args):
        gui = self.plugin_action.gui
        index = gui.library_view.currentIndex()
        book_id = gui.library_view.model().id(index)
        if gui.grid_view_button.isChecked():
            column_name = ''
        else:
            model = index.model()
            column_map = model.column_map
            column_name = column_map[index.column()]
            self.book_list_enter_key_pressed.emit(book_id, column_name)
    
    def get_event_signal(self):
        return self.book_list_enter_key_pressed

