#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2021, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import inspect

from calibre import prints
from calibre.utils.formatter_functions import FormatterUserFunction, StoredObjectType

try:
    load_translations()
except NameError:
    prints("ActionsChain/templates/functions/base.py - exception when loading translations")

class TemplateFunction(FormatterUserFunction):

    doc = _('No documentation provided')
    name = 'no name provided'
    category = ''
    arg_count = 0
    aliases = []

    def __init__(self, plugin_action):
        self.plugin_action = plugin_action
        # used by some functions to modify behaviour when in template dialog
        self.context = None
        self.object_type = StoredObjectType.PythonFunction

    @property
    def program_text(self):
        try:
            source = inspect.getsource(self.evaluate)
        except:
            source = ''
        return source

    def on_template_dialog_start(self, dialog):
        self.context = 'template_dialog_mode'

    def on_template_dialog_exit(self, dialog):
        self.context = None
