#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__   = 'GPL v3'
__copyright__ = '2021 additions by Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import json
from collections import OrderedDict

from calibre import prints
from calibre.constants import DEBUG

from calibre_plugins.category_tags.user_categories.formats.base import UserCategoriesFormat

try:
    load_translations()
except NameError:
    prints("Category Tags::user_categories/formats/json.py - exception when loading translations")

class JSONFormat(UserCategoriesFormat):

    name = 'json'
    description = 'JSON'
    filters = [(_('Categories'), ['json'])]
    _is_builtin = True

    def to_pivot(self, file_path, settings):
        pivot_format = {}
        with open(file_path, 'r') as f:
            d = json.load(f)
            for cat_name, record in d.items():
                for item, item_type in record:
                    if not pivot_format.get(item_type):
                        pivot_format[item_type] = {}
                    if not pivot_format[item_type].get(item):
                        pivot_format[item_type][item] = {'categories': set()}
                    pivot_format[item_type][item]['categories'].add(cat_name)
        return pivot_format

    def from_user_categories(self, user_categories, file_path, settings):
        d = OrderedDict()
        for category, category_items in user_categories.items():
            d[category] = []
            for category_item in category_items:
                item, item_type, _ign = category_item
                new_category_item = [item, item_type]
                d[category].append(new_category_item)

        with open(file_path, 'w') as f:
            json.dump(d, f, indent=4)
