#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__   = 'GPL v3'
__copyright__ = '2021 additions by Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import traceback

from calibre import prints
from calibre.constants import DEBUG

from calibre_plugins.category_tags.user_categories import get_cols

try:
    load_translations()
except NameError:
    prints("Category Tags::user_categories/formats/base.py - exception when loading translations")

class UserCategoriesFormat(object):

    name = ''
    identifier = ''
    filters = []

    def __init__(self, gui):
        self.gui = gui
        self.db = self.gui.current_db
        self.all_item_types = list(get_cols(self.db))

    def to_pivot(self, file_path, settings):
        # {
        #     item_type: {
        #         item: {
        #             'categories': set(),
        #             'note': str()
        #         }
        #     }
        # }
        #
        # {
        #     'authors': {
        #         'Naguib Mahfouz': {
        #             'categories': set(['Awards.Nobel','Nationality.Egyptian']),
        #             'note': "Naguib Mahfouz Abdelaziz Ibrahim Ahmed Al-Basha (Arabic: نجيب محفوظ عبد العزيز ابراهيم احمد الباشا, IPA: [næˈɡiːb mɑħˈfuːzˤ]; 11 December 1911 – 30 August 2006) was an Egyptian writer who won the 1988 Nobel Prize in Literature."
        #         }
        #     }
        # }
        raise NotImplementedError

    def from_user_categories(self):
        raise NotImplementedError

    def config_widget(self):
        return None

    def default_settings(self):
        return {}

    def validate(self, settings):
        return True

    def get_note(self, field_name, field_value, plain_text=False):
        try:
            note = None
            item_id = self.db.new_api.get_item_id(field_name, field_value, case_sensitive=True)
            if item_id is not None:
                note = self.db.new_api.notes_data_for(field_name, item_id)
                if note is not None:
                    if plain_text:
                        note = note['searchable_text'].partition('\n')[2]
                    else:
                        from lxml import html

                        from calibre.db.notes.exim import expand_note_resources, parse_html
                        # Return the full HTML of the note, including all images
                        # as data: URLs. Reason: non-exported note html contains
                        # "calres://" URLs for images. These images won't render
                        # outside the context of the library where the note
                        # "lives". For example, they don't work in book jackets
                        # and book details from a different library. They also
                        # don't work in tooltips.

                        # This code depends on the note being wrapped in <body>
                        # tags by parse_html. The body is changed to a <div>.
                        # That means we often end up with <div><div> or some
                        # such, but that is OK
                        root = parse_html(note['doc'])
                        # There should be only one <body>
                        root = root.xpath('//body')[0]
                        # Change the body to a div
                        root.tag = 'div'
                        # Expand all the resources in the note
                        root = expand_note_resources(root, self.db.new_api.get_notes_resource)
                        note = html.tostring(root, encoding='unicode')
            return '' if note is None else note
        except Exception as e:
            traceback.print_exc()
            raise ValueError(e)
