#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__   = 'GPL v3'
__copyright__ = '2021 additions by Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from calibre import prints
from calibre.constants import DEBUG

try:
    load_translations()
except NameError:
    prints("Category Tags::user_categories/__init__.py - exception when loading translations")

from calibre_plugins.category_tags.advanced_matching import validate_match_rule


def get_cols(db):
    standard = ['authors','publisher','tags','series']
    custom = []
    for field, cmeta in db.field_metadata.custom_field_metadata().items():
        if cmeta['kind'] == 'field':
            if cmeta['datatype'] in ['series']:
                custom.append(field)
            elif cmeta['datatype'] == 'text' and cmeta['is_category']:
                custom.append(field)
    return standard + custom

def validate_category_match_rules(gui, category_match_rules, possible_cols):
    find_duplicates_plugin_action = gui.iactions['Category Tags']
    flag = True
    all_errors = ''
    name = category_match_rules['name']
    match_rules = category_match_rules.get('settings', [])
    if len(match_rules) == 0:
        return (_('Match rules error'), _('No match rules configured for this category'))
    else:
        match_rule = match_rules[0]
        algorithms = gui.iactions['Category Tags'].algorithms
        is_valid = validate_match_rule(gui, algorithms, match_rule, possible_cols)
        if is_valid is not True:
            msg, details = is_valid
            return msg, details     
    return True

def validate_all_categories_match_rules(gui, possible_cols, categories_match_rules):
    all_categories_match_rules_valid  = True
    for row, category_match_rules in enumerate(categories_match_rules):
        is_category_match_rules_valid = validate_category_match_rules(gui, category_match_rules, possible_cols)
        if is_category_match_rules_valid is not True:
            all_categories_match_rules_valid  = False
            msg, details = is_category_match_rules_valid
    return all_categories_match_rules_valid 
