#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__   = 'GPL v3'
__copyright__ = '2023, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from calibre_plugins.category_tags.advanced_matching.matching import MetadataMatch
from calibre_plugins.action_chains.common_utils import load_plugin

def on_modules_update(user_modules):
    plugin = load_plugin('Category Tags')
    plugin.user_algorithm_classes = {}
    for cls in user_modules.get_classes(class_filters=[MetadataMatch]):
        name = cls.name
        # must define a name attribute, must be set and not clash with builtin names
        # which can be imported into the module manager by custom actions
        if name in ['', MetadataMatch.name]:
            continue
        plugin.user_algorithm_classes[name] = cls
    plugin.update_algorithms()
    #
    plugin.import_action.on_modules_update(user_modules)
    plugin.export_action.on_modules_update(user_modules)
