#!/usr/bin/env python 
# -*- coding: utf-8 -*- 
import sys

_CaseChgFunctions = {
    
    "uppercase": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_uppercase(match, number, file_name, metadata, data)\n",
            
    "lowercase": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_lowercase(match, number, file_name, metadata, data)\n",

    "capitalize": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_capitalize(match, number, file_name, metadata, data)\n",

    "titlecase": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_titlecase(match, number, file_name, metadata, data)\n",

    "swapcase": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_swapcase(match, number, file_name, metadata, data)\n",

    "uppercase_ignore_tags": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_uppercase_ignore_tags(match, number, file_name, metadata, data)\n",

    "lowercase_ignore_tags": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_lowercase_ignore_tags(match, number, file_name, metadata, data)\n",

    "capitalize_ignore_tags": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_capitalize_ignore_tags(match, number, file_name, metadata, data)\n",

    "titlecase_ignore_tags": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_titlecase_ignore_tags(match, number, file_name, metadata, data)\n",

    "swapcase_ignore_tags": "def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn replace_swapcase_ignore_tags(match, number, file_name, metadata, data)\n"
            
}


def run(BookContainer): 
    print("Entered Target Script run() routine")

    try:
        import PySide6.QtWidgets
        import PySide6.QtCore
        import PySide6.QtGui
        print("import PySide6 success")
    except ImportError:
        print("Missing PySide6")
        return 1
    from PySide6.QtCore import Qt
    from PySide6.QtWidgets import QApplication,QWidget,\
                                QHBoxLayout,QSplitter
    from SearchSplitterWidget import SearchSplitterWidget
    from PrintWidget import PrintWidget
    prefs = BookContainer.getPrefs()
    if 'func' not in prefs:
        prefs['func']= _CaseChgFunctions
    functionPrefs=prefs['func']
    oldStdout=sys.stdout
    app = QApplication(sys.argv)
    widget = QWidget()

    mainSplitter=QSplitter(Qt.Orientation.Horizontal)
    mainSplitter.addWidget(SearchSplitterWidget(BookContainer,functionPrefs))
    printWidget=PrintWidget()
    mainSplitter.addWidget(printWidget)
    sys.stdout = printWidget

    mainLayout=QHBoxLayout()
    mainLayout.addWidget(mainSplitter)
    widget.setLayout(mainLayout)
    widget.show()
    app.exec()
    sys.stdout=oldStdout
    BookContainer.savePrefs(prefs)
    return 0

def main(): 
    print("I reached main when I should not have\n")
    return -1

if __name__ == "__main__":
    sys.exit(main())
