from BorderFrame import BorderFrame
from PySide6.QtCore import Qt
from PySide6.QtWidgets import QGridLayout,QLabel,QLineEdit,QPushButton,QComboBox,QInputDialog,QMessageBox
from PySide6.QtCore import Signal
from enum import Enum,unique
@unique
class FindMode(Enum):
    all_html='All HTML files'
    selected_html='Selected HTML files'
    all_css='All CSS files'
    selected_css='Selected CSS files'
    all_selected='All files selectd'
    all_file='All files'
    #opf='OPF file'
    #ncx='NCX file'

class SearchGridWidget(BorderFrame):
    functionSelectedSignal = Signal(str)
    replaceAllSignal = Signal(str,str,str)
    emptyFunctionText='def replace(match, number, file_name, metadata, data):\n\tif match:\n\t\treturn match.group(0)'
    def __init__(self,functionPrefs ={},parent=None) -> None:
        super().__init__(parent)
        self.functionPrefs=functionPrefs
        self.searchLayout=QGridLayout()

        self.findLabel=QLabel("Find")
        self.findLabel.setMaximumWidth(120)
        self.findLabel.setAlignment(Qt.AlignmentFlag.AlignRight|Qt.AlignmentFlag.AlignVCenter)
        self.findLineEdit=QLineEdit()
        self.findReplacePushButton=QPushButton("Replace All")
        self.findReplacePushButton.setMaximumWidth(120)
        self.findReplacePushButton.clicked.connect(self.replaceAll)
        self.searchLayout.addWidget(self.findLabel,0,0)
        self.searchLayout.addWidget(self.findLineEdit,0,1,1,2)
        self.searchLayout.addWidget(self.findReplacePushButton,0,3)

        self.modeLabel=QLabel("Mode")
        self.modeLabel.setMaximumWidth(120)
        self.modeLabel.setAlignment(Qt.AlignmentFlag.AlignRight|Qt.AlignmentFlag.AlignVCenter)
        self.modeRangeComboBox=QComboBox()
        #list(map(lambda x:self.modeRangeComboBox.addItem(x.value),FindMode))
        self.modeRangeComboBox.addItems(map(lambda x:x.value,FindMode))
        '''
        self.modeDirectionComboBox=QComboBox()
        self.modeDirectionComboBoxItems=[
            'Up',
            'Down'
            ]
        self.modeDirectionComboBox.addItems(self.modeDirectionComboBoxItems)
        self.modeDirectionComboBox.setMaximumWidth(120)
        self.searchLayout.addWidget(self.modeDirectionComboBox,1,2)
        '''
        self.searchLayout.addWidget(self.modeLabel,1,0)
        self.searchLayout.addWidget(self.modeRangeComboBox,1,1,1,2)

        self.functionLabel=QLabel("Function")
        self.functionLabel.setMaximumWidth(120)
        self.functionLabel.setAlignment(Qt.AlignmentFlag.AlignRight|Qt.AlignmentFlag.AlignVCenter)
        self.functionSelectComboBox=QComboBox()
        self.functionSelectComboBox.addItems(list(functionPrefs.keys()))
        self.functionSelectComboBox.currentTextChanged.connect(self.selectFunction)
        self.functionNewPushButton=QPushButton("New")
        self.functionNewPushButton.setMaximumWidth(120)
        self.functionNewPushButton.clicked.connect(self.createFunction)
        self.functionDeletePushButton=QPushButton("Delete")
        self.functionDeletePushButton.setMaximumWidth(120)
        self.functionDeletePushButton.clicked.connect(self.deleteFunction)
        self.searchLayout.addWidget(self.functionLabel,2,0)
        self.searchLayout.addWidget(self.functionSelectComboBox,2,1)
        self.searchLayout.addWidget(self.functionNewPushButton,2,2)
        self.searchLayout.addWidget(self.functionDeletePushButton,2,3)

        self.searchLayout.setRowStretch(3, 1)
        self.setLayout(self.searchLayout)

    def selectFunction(self,name):
        self.functionSelectedSignal.emit(name)
    def replaceAll(self):
        if self.functionSelectComboBox.currentIndex()!=-1:
            self.replaceAllSignal.emit(self.findLineEdit.text(),self.functionSelectComboBox.currentText(),self.modeRangeComboBox.currentText())

    def createFunction(self):
        name,ok=QInputDialog.getText(self,"Input Name","Input Function Name")
        if ok:
            if not name:
                QMessageBox.warning(self,"waring","Name can not be empty")
            elif name in self.functionPrefs:
                QMessageBox.warning(self,"waring","Name can not duplicate")
            else:
                self.functionPrefs[name]=self.emptyFunctionText
                self.functionSelectComboBox.addItem(name)
                self.functionSelectComboBox.setCurrentText(name)
    def deleteFunction(self):
        name=self.functionSelectComboBox.currentText()
        index=self.functionSelectComboBox.currentIndex()
        
        if index!=-1:
            self.functionSelectComboBox.removeItem(index)
            del self.functionPrefs[name]
    def getFunctionName(self):
        return self.functionSelectComboBox.currentText()
