from PySide6.QtWidgets import QSplitter
from PySide6.QtCore import Qt
from SearchGridWidget import SearchGridWidget,FindMode
from FunctionEditorWidget import FunctionEditorWidget
from functionrep import *

import re
class SearchSplitterWidget(QSplitter):
    def __init__(self,BookContainer,functionPrefs ={}, parent= None) :
        super().__init__(Qt.Orientation.Vertical,parent)
        self.functionPrefs=functionPrefs
        self.BookContainer=BookContainer
        self.functionEditorWidget=FunctionEditorWidget()
        # bug in PySide6 when connecting to doSave the first time it fails
        # but the second time it succeeds - no idea why - and onluy for this signal/slot pairing
        self.functionEditorWidget.textChanged.connect(self.doSave0)
        self.functionEditorWidget.textChanged.connect(self.doSave)
        self.searchGridWidget= SearchGridWidget(functionPrefs)
        self.searchGridWidget.functionSelectedSignal.connect(self.selectFunction)
        self.searchGridWidget.replaceAllSignal.connect(self.replaceAll)
        self.addWidget(self.searchGridWidget)
        self.addWidget(self.functionEditorWidget)
        self.selectFunction(self.searchGridWidget.getFunctionName())
        
    def selectFunction(self,name):
        if name:
            self.functionEditorWidget.setPlainText(self.functionPrefs[name])
        else:
            self.functionEditorWidget.clear()

    def doSave0(self):
        return

    def doSave(self):
        name=self.searchGridWidget.getFunctionName()
        if name:
            self.functionPrefs[name]=self.functionEditorWidget.toPlainText()

    def replaceAll(self,pattern,name,mode):
        def iterConvert(iterator):
            print(map(lambda x:(x[1],self.BookContainer.id_to_href(x[1])),filter(lambda x:x[0]=='manifest',iterator)))
            return map(lambda x:(x[1],self.BookContainer.id_to_href(x[1])),filter(lambda x:x[0]=='manifest',iterator))
        # add the standard case change functions globally
        global replace_lowercase
        global replace_uppercase
        global replace_capitalize
        global replace_titlecase
        global replace_swapcase
        global replace_lowercase_ignore_tags
        global replace_uppercase_ignore_tags
        global replace_capitalize_ignore_tags
        global replace_titlecase_ignore_tags
        global replace_swapcase_ignore_tags
        func=self.functionPrefs[name]
        replaceDict= globals()
        exec(func,replaceDict)
        if 'replace' in replaceDict:
            replace=replaceDict['replace']
            if hasattr(replace, '__call__'):
                global count
                global filename
                global funcData
                count=1
                filename=''
                funcData={}
                def repl(match):
                    global count
                    global filename
                    global funcData
                    if match:
                        result=match.group(0)
                    else:
                        result=''
                    try:
                        if filename:
                            print("Match found: ", filename, count)
                        result=replace(match,count,filename,self.BookContainer.getmetadataxml(),funcData)
                    except Exception as e:
                        print(e)
                    count+=1
                    return result
                if mode==FindMode.all_html.value:
                    aniter=self.BookContainer.text_iter()
                elif mode==FindMode.selected_html.value:
                    aniter=filter(lambda x:x[1].endswith('.html') or x[1].endswith('.xhtml') ,iterConvert(self.BookContainer.selected_iter()))
                elif mode==FindMode.all_css.value:
                    aniter=self.BookContainer.css_iter()
                elif mode==FindMode.selected_css.value:
                    aniter=filter(lambda x:x[1].endswith('.css'),iterConvert(self.BookContainer.selected_iter()))
                elif mode==FindMode.all_selected.value:
                    aniter=iterConvert(self.BookContainer.selected_iter())
                elif mode==FindMode.all_file.value:
                    aniter=map(lambda x:(x[0],x[1]),self.BookContainer.manifest_iter())
                for manifest_id, OPF_href in aniter:
                    # print(manifest_id, OPF_href)
                    data=self.BookContainer.readfile(manifest_id)
                    if isinstance(data, str):
                        filename=self.BookContainer.href_to_basename(OPF_href)
                        data=re.sub(pattern,repl,data,flags=re.M)
                        self.BookContainer.writefile(manifest_id,data)
                print("Replace All Completed")
                filename=''
                # repl(None)
