from PySide6.QtWidgets import QPlainTextEdit
from PySide6 import QtGui
from PySide6 import QtCore
from PythonSyntaxHighlighter import PythonSyntaxHighlighter
class FunctionEditorWidget(QPlainTextEdit):
    def __init__(self,parent=None):
        super().__init__(parent)
        self.pythonHighlighter=PythonSyntaxHighlighter(self.document())
        self.setTabStopDistance(QtGui.QFontMetricsF(self.font()).horizontalAdvance(' ') * 4)

    # override the event handler to detect dark vs light theme changes
    def event(self, e):
        if e.type() == QtCore.QEvent.PaletteChange:
            # print('Palette Changed')
            self.pythonHighlighter.do_rehighlight()
        return super().event(e)

