#!/bin/sh
#
# Based from NiLuJe scripts.
#

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}

# ========== Variables ==========

INST_LOG="/mnt/us/reginfo_backup.log"
REG_INFO="/var/local/java/prefs/reginfo"
REG_BAK="/mnt/us/reginfo.bak"

# =========== Logging ===========

MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    [ "$_MSG_LEVEL" != "D" ] && echo "OTA_install: level $_MSG_LEVEL: $_MSG_COMP: $_FREETEXT" >> ${INST_LOG}
}

# ========= Progress bar ========

if [ -z "${_PERCENT_COMPLETE}" ]; then
    export _PERCENT_COMPLETE=0
fi

update_percent_complete()
{
    _PERCENT_COMPLETE=$((${_PERCENT_COMPLETE} + $1))
    update_progressbar ${_PERCENT_COMPLETE}
}

# =========== Backup ============

update_percent_complete 0
sleep 1

echo "Start backup: `date`" >> ${INST_LOG}

update_percent_complete 20
sleep 1

if [ -f ${REG_INFO} ]; then
    logmsg "I" "make" "Create backup file ${REG_BAK}"
    cp -f ${REG_INFO} ${REG_BAK} 2>> ${INST_LOG}
else
    logmsg "I" "check" "Registration file ${REG_INFO} not found"
fi

update_percent_complete 80
sleep 1

echo "Complete backup: `date`" >> ${INST_LOG}

update_progressbar 100
sleep 1

# =========== Finish ============

return 0
