#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2024 seeder'
__docformat__ = 'restructuredtext en'

try:
    load_translations()
except NameError:
    pass # load_translations() added in calibre 1.9

class PluginPrefsName():
    STORE_NAME               = 'Options'
    KEY_MAX_DOWNLOADS        = 'maxDownloads'
    MAX_COVERS               = 'maxCoverDownloads'
    OBALKYKNIH_COVER         = 'obalkyKnihCover'
    BOOKPORT_COVER           = 'bookportCover'
    IDENTIFIER_SEARCH        = 'identifierSearch'
    ISBN_SEARCH              = 'isbnSearch'
    TALES_SEARCH             = 'talesSearch'
    AUDIOBOOK_SEARCH         = 'audiobookSearch'
    ISSUE_PREFERENCE         = 'issuePreference'
    GOOGLE_SEARCH            = 'googleSearchEngine'
    DUCKDUCKGO_SEARCH        = 'duckduckgoSearchEngine'

    AUTHORS_INCLUDE          = 'authorsInclude'
    REAL_AUTHS_INCLUDE       = 'realAuthorsNameInclude'
    TRANSLATORS_INCLUDE      = 'translatorsInclude'
    ILLUSTRATORS_INCLUDE     = 'illustratorsInclude'
    COVER_AUTHORS_INCLUDE    = 'coverAuthorsInclude'
    INTERPRETS_INCLUDE       = 'interpretsInclude'
    ONE_AUTHOR               = 'oneAuthor'
    AUTHOR_ROLE              = 'authorRole'
    SWAP_AUTHORS             = 'swapAuthors'

    SERIES_EDITIONS          = 'seriesEditions'
    SERIES_LOCALIZATION      = 'seriesLocalization'
    PUBLICATION_DATE         = 'publicationDate'
    CALCULATE_RATING         = 'calculatedRating'
    CALCULATE_RATING_ACCURACY = 'calculatedRatingAccuracy'

    APPEND_TO_COMMENTS       = 'appendToComments'
    APPEND_TO_TAG            = 'appendToTag'
    APPEND_TO_IDENTIFIERS    = 'appendToIdentifiers'
    TITLE_LINE               = 'customTitle'
    PUBLISHER_LINE           = 'customPublisher'
    SERIES_LINE              = 'customSeries'
    SERIES_INDEX_FIELD       = 'seriesIndexField'
    SERIES_INDEXING_ITEM     = 'seriesIndexingItem'

    KEY_CATEGORY_MAPPINGS    = 'categoryMappings'
    KEY_GENRE_MAPPINGS       = 'genreMappings'
    KEY_SERIES_MAPPINGS      = 'seriesMappings'
    KEY_PUBLISHER_MAPPINGS   = 'publisherMappings'
    GENRE_FILTER             = 'genreFilter'
    CATEGORY_FILTER          = 'categoryFilter'
    SERIES_FILTER            = 'seriesFilter'
    PUBLISHER_FILTER         = 'publisherFilter'

class MetadataIdentifier():
    DESCRIPTION              = 'description'
    HR                       = 'hr'
    CUSTOM_TEXT              = 'customText'
    PAGES                    = 'appendPages'
    COVER_TYPE               = 'appendCoverType'
    PRINT_RUN                = 'appendPrintRun'
    AUDIO_LENGTH             = 'appendAudioLength'
    ORIGINAL_TITLE           = 'appendOriginalTitle'
    TITLE                    = 'appendTitle'
    ORIGINAL_YEAR            = 'appendOriginalYear'
    PUB_YEAR                 = 'appendPubYear'
    ORIGINAL_DATE            = 'appendOriginalDate'
    PUB_DATE                 = 'appendPubDate'
    PUBLISHER                = 'appendPublisher'
    AUTHORS                  = 'appendAuthors'
    REAL_AUTHORS             = 'appendRealAuthors'
    TRANSLATION              = 'appendTranslation'
    ILLUSTRATION             = 'appendIllustration'
    COVER_AUTHORS            = 'appendCoverAuthors'
    INTERPRETS               = 'appendInterprets'
    SERIES                   = 'appendSeries'
    SERIES_INDEX             = 'appendSeriesIndex'
    EDITION                  = 'appendEdition'
    EDITION_INDEX            = 'appendEditionIndex'
    GENRES                   = 'appendGenres'
    TAGS                     = 'appendTags'
    RATING                   = 'appendRating'
    RATING5                  = 'appendRating5'
    RATING10                 = 'appendRating10'
    RATING_COUNT             = 'appendRatingCount'
    READ_TEMPO               = 'appendRatingReadTempo'
    RATING_EMOTIONS          = 'appendRatingEmotions'
    ISBN                     = 'appendIsbn'
    ORIG_ID                  = 'appendOrigDK'
    AWARDS                   = 'awards'
    TALES_IN_BOOK            = 'appendTalesInBook'
    TRIVIA                   = 'appendTrivia'
    CONTAINED_IN             = 'appendContainedIn'
    SOURCE_RELEVANCE         = 'sourceRelevance'
    CATEGORY                 = 'appendCategory'
    EAN                      = 'ean'
    LANGUAGE                 = 'language'
    PRICE                    = 'price'
    DIMENSIONS               = 'dimensions'
    PRINT_RUN                = 'print_run'
    ISSUE_NUMBER             = 'issue_number'
    ALT_TITLE                = 'alt_title'
    SEP_PUBLISHED            = 'sep_published'
    CONTAINED_IN             = 'contained_in'
    WORLD                    = 'world'
    ALT_ORIGINAL_TITLE       = 'alt_original_title'
    SUBTITLE                 = 'subtitle'
    NOTE                     = 'note'
    EXTERNAL_LINKS           = 'external_links'

class MetadataName():
    DESCRIPTION              = _('Description')
    HR                       = _('——— (Horizontal line)')
    CUSTOM_TEXT              = _('Custom text')
    PAGES                    = _('Pages count')
    COVER_TYPE               = _('Cover type')
    PRINT_RUN                = _('Print run')
    AUDIO_LENGTH             = _('Audio length')
    ORIGINAL_TITLE           = _('Original title')
    TITLE                    = _('Title')
    ORIGINAL_YEAR            = _('Original pub year')
    PUB_YEAR                 = _('Publication year')
    ORIGINAL_DATE            = _('Original pubdate')
    PUB_DATE                 = _('Publication date')
    PUBLISHER                = _('Publisher')
    AUTHORS                  = _('Authors')
    REAL_AUTHORS             = _('Real authors')
    TRANSLATION              = _('Translators')
    ILLUSTRATION             = _('Illustrators')
    COVER_AUTHORS            = _('Book cover authors')
    INTERPRETS               = _('Interprets')
    SERIES                   = _('Series')
    SERIES_INDEX             = _('Series index')
    EDITION                  = _('Book Edition')
    EDITION_INDEX            = _('Book Edition index')
    GENRES                   = _('Genre')
    TAGS                     = _('Tags')
    RATING                   = _('Rating (%)')
    RATING5                  = _('Rating (0-5)')
    RATING10                 = _('Rating (0-10)')
    RATING_COUNT             = _('Rating count')
    READ_TEMPO               = _('Read tempo (slow 0-100 fast)')
    RATING_EMOTIONS          = _('Emotions')
    ISBN                     = _('ISBN')
    ORIG_ID                  = _('Site identifier')
    AWARDS                   = _('Awards')
    TALES_IN_BOOK            = _('Tales in book')
    TRIVIA                   = _('Trivia')
    CONTAINED_IN             = _('Contained in books')
    SOURCE_RELEVANCE         = _('Source relevance')
    EAN                      = _('EAN')
    PRICE                    = _('Price')
    LANGUAGE                 = _('Language')
    DIMENSIONS               = _('Dimensions')
    ISSUE_NUMBER             = _('Issue number')
    ALT_TITLE                = _('Alternative titles')
    SEP_PUBLISHED            = _('Published separately as')
    WORLD                    = _('World')
    ALT_ORIGINAL_TITLE       = _('Alternative original title')
    SUBTITLE                 = _('Subtitle')
    NOTE                     = _('Note')
    CATEGORY                 = _('Category')
    EXTERNAL_LINKS           = _('External links')

class TranslatingStrings():
    DEFAULTS_RESET_TITLE = _('Restart plugin to defaults')
    DEFAULTS_RESET_TOOLTIP = _('Reset plugin to defaults (Alt+Shift+R)')
    CONFIRMATION_TITLE = _('Are you sure?')
    ADD_ITEM_TITLE = _("Add item")
    CHOOSE_ITEM_TITLE = _("Choose item:")
    ADD_CUSTOM_TEXT_TITLE = _("Add custom text")
    ADD_CUSTOM_TEXT_INFO = _("Write text:")
    CONFIRMATION_DEFAULTS_INFO = _('Are you sure you want to reset plugin to default settings?')
    DELETE_ITEM_INFO = _('Are you sure you want to delete the selected item?')
    DELETE_MAPPING_INFO = _('Are you sure you want to delete selected mappings?')
    APPEND_ALL_INFO = _('Are you sure you want to delete your order and add all available items?')
    DEFAULTS_BUILDER_RESET_INFO = _('Are you sure you want to set builder to defaults?')
    DEFAULTS_MAPPING_RESET_INFO = _('Are you sure you want to reset to the plugin default mappings?')
    ADD_MAPPING_TITLE = _('Add new mapping')
    ADD_MAPPING_INFO = _('Enter a website name of an item to create a mapping for:')
    RENAME_MAPPING_TITLE = _('Rename mapping')
    RENAME_MAPPING_INFO = _('Enter a website name of an item to create a mapping for:')
    ADD_MAPPING_ERROR_TITLE = _('Adding Failed')
    ADD_MAPPING_ERROR_INFO = _('Mapping with the same name already exists.')
    RENAME_MAPPING_ERROR_TITLE = _('Renaming Failed')
    RENAME_MAPPING_ERROR_INFO = _('An item with the same name already exists.')
    CUSTOM_COLUMNS_INFO = _('How to create custom column from this Identificators? Check <a href="https://www.mobileread.com/forums/showpost.php?p=4361821&postcount=2">MobileRead</a> forum.')
    APPEND_IDENTIFIER_TITLE = _("Select what will be added into 'Identifiers' metadata field in Calibre")
    RATING_TITLE = _('Rating')
    RECALCULATE_RATING_TITLE = _('Recalculate ratings')
    RECALCULATE_RATING_INFO = _('Enable this option if you want to parse more accurate rating (it will be calculated from individual ratings) from site.\nIf unchecked, only provided rating on main book page will be parsed.')
    RATING_DECIMAL_TITLE = _('Max decimal places')
    RATING_DECIMAL_INFO = _('With this option you can change accuracy of the float number.\n**ONLY in recalculated rating')
    APPEND_COMMENTS_TITLE = _('Comment builder (What will be parsed into Comments field.)')
    APPEND_TAGS_TITLE = _("Select what will be added into 'Tags' metadata field in Calibre")
    APPEND_PUBLISHER_TITLE = _("Set what will be parsed into Calibre 'Publisher' field")
    APPEND_PUBLISHED_TITLE = _("Set what will be parsed into Calibre 'Published date' field")
    APPEND_PUBLISHED_INFO = _('You can select date of first publication or this publication to be parsed here.')
    APPEND_SERIES_TITLE = _("Set what will be parsed into Calibre 'Series' column")
    APPEND_SERIES_INDEX_TITLE = _("Set what will be parsed into Calibre 'series_index'")
    APPEND_SERIES_INDEX_INFO = _('You can select any number value here.')
    APPEND_AUTHORS_TITLE = _("Select what will be added into 'Authors' metadata field in Calibre")
    APPEND_TITLE_TITLE = _("Set what will be parsed into Calibre 'Title' column")
    MAX_DOWNLOADS_TITLE = _('Maximum title/author search matches to evaluate (1 = fastest):')
    MAX_DOWNLOADS_INFO = _('Number of maximum search results which you can get from site.')
    ISBN_SEARCH_INFO = _('If isbn identifier found in book metadata, plugin will use it for faster book search.')
    AUDIOBOOK_SEARCH_TITLE = _('Audiobook')
    AUDIOBOOK_SEARCH_INFO = _('Try to prefer audiobook issue of the book if exists.')
    BOOK_SEARCH_TITLE = _('Books')
    BOOK_SEARCH_INFO = _('Search for books\n\nusing built-in search engine:\n whole title + last name of first author > only title + all authors > whole title > only one word from title (longest first) >\n'\
                        '> all authors > only one author > only one part of authors name\n\nusing Google/DuckDuckGo search engine: title + all authors')
    TALES_SEARCH_TITLE = _('Tales')
    TALES_SEARCH_INFO = _("Check this if you want to search in tales before searching in books.\n"\
                        "Search for tales/poems attempts:\ntitle + all authors > only whole title > only one word from title (longest first)")
    SEARCH_ENGINE_TITLE = _('Search engine')
    GOOGLE_SEARCH_TITLE = _('Google search')
    GOOGLE_SEARCH_INFO = _('Tries to search for book or tale/poem via google search engine prior to built-in site search.')
    DUCKDUCKGO_SEARCH_TITLE = _('DuckDuckGo search')
    DUCKDUCKGO_SEARCH_INFO = _('Tries to search for book or tale/poem via DuckDuckGo search engine prior to built-in site search.')
    BUILTIN_SEARCH_TITLE = _('Built-in search')
    BUILTIN_SEARCH_INFO = _('Tries to search for book or tale/poem via built-in site search engine.')
    BOOK_ISSUE_TITLE = _('Book issues')
    BOOK_ISSUE_COMBO_TITLE = _('Choose preferred book issue')
    BOOK_ISSUE_COMBO_INFO = _('Set which issue of the book will be preferred. You can choose between czech/slovak and oldest/newest.\nDefault will be chosen if specified issue not found.')
    COVERS_TITLE = _('Covers')
    COVERS_DOWNLOAD_TITLE = _('Maximum covers from other issues to evaluate (1 = fastest):')
    COVERS_DOWNLOAD_INFO = _('Set max covers to download. Faster evaluating if set to 1 with Default preferred issue set\n\n'\
                            'When set to 0 - no covers will be downloaded.\n'\
                            'When set to 1 and preferred book issue option set to default - only default found issue cover will be downloaded.\n'\
                            'When set to >1 all covers from preferred issue language are downloaded\n'\
                            '- When preferred czech only all czech cover gets downloaded and vice-versa (default option recognizes language of default book)\n'\
                            '- oldest/newest order does matter if max cover option < available covers')
    COMMENT_ITEM = _('Comment item')
    TAG_ITEM = _('Tag item')
    METADATA_ITEM = _('Metadata Item')
    IDENTIFIER_FORMAT = _('Identifier format')
    MAPS_TO_CALIBRE = _('Maps to Calibre')
