#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2024 seeder'
__docformat__ = 'restructuredtext en'

import copy
from calibre_plugins.legie.shared.prefs import PluginPrefsName, MetadataIdentifier, MetadataName
from calibre.utils.config import JSONConfig

try:
    load_translations()
except NameError:
    pass # load_translations() added in calibre 1.9

LINE_OPTIONS = [
        (MetadataIdentifier.CUSTOM_TEXT, True, MetadataName.CUSTOM_TEXT),
        (MetadataIdentifier.TITLE, True, MetadataName.TITLE),
        (MetadataIdentifier.ORIGINAL_TITLE, True, MetadataName.ORIGINAL_TITLE),
        (MetadataIdentifier.PUBLISHER, True, MetadataName.PUBLISHER),
        (MetadataIdentifier.AUTHORS, True, MetadataName.AUTHORS),
        (MetadataIdentifier.TRANSLATION, True, MetadataName.TRANSLATION),
        (MetadataIdentifier.ILLUSTRATION, True, MetadataName.ILLUSTRATION),
        (MetadataIdentifier.COVER_AUTHORS, True, MetadataName.COVER_AUTHORS),
        (MetadataIdentifier.ORIGINAL_YEAR, True, MetadataName.ORIGINAL_YEAR),
        (MetadataIdentifier.PUB_YEAR, True, MetadataName.PUB_YEAR),
        (MetadataIdentifier.ORIGINAL_DATE, True, MetadataName.ORIGINAL_DATE),
        (MetadataIdentifier.PUB_DATE, True, MetadataName.PUB_DATE),
        (MetadataIdentifier.PAGES, True, MetadataName.PAGES),
        (MetadataIdentifier.COVER_TYPE, True, MetadataName.COVER_TYPE),
        (MetadataIdentifier.PRINT_RUN, True, MetadataName.PRINT_RUN),
        (MetadataIdentifier.SERIES, True, MetadataName.SERIES),
        (MetadataIdentifier.SERIES_INDEX, True, MetadataName.SERIES_INDEX),
        (MetadataIdentifier.EDITION, True,MetadataName.EDITION),
        (MetadataIdentifier.EDITION_INDEX, True, MetadataName.EDITION_INDEX),
        (MetadataIdentifier.CATEGORY, True, MetadataName.CATEGORY),
        (MetadataIdentifier.RATING, True, MetadataName.RATING),
        (MetadataIdentifier.RATING10, True, MetadataName.RATING10),
        (MetadataIdentifier.RATING5, True, MetadataName.RATING5),
        (MetadataIdentifier.RATING_COUNT, True, MetadataName.RATING_COUNT),
        (MetadataIdentifier.ISBN, True, MetadataName.ISBN),
        (MetadataIdentifier.ORIG_ID, True, MetadataName.ORIG_ID),
        (MetadataIdentifier.SOURCE_RELEVANCE, True, MetadataName.SOURCE_RELEVANCE),
        (MetadataIdentifier.EAN, True, MetadataName.EAN),
        (MetadataIdentifier.PRICE, True, MetadataName.PRICE),
        (MetadataIdentifier.LANGUAGE, True, MetadataName.LANGUAGE),
        (MetadataIdentifier.DIMENSIONS, True, MetadataName.DIMENSIONS),
        (MetadataIdentifier.ISSUE_NUMBER, True, MetadataName.ISSUE_NUMBER),
        (MetadataIdentifier.ALT_TITLE, True, MetadataName.ALT_TITLE),
        (MetadataIdentifier.SEP_PUBLISHED, True, MetadataName.SEP_PUBLISHED),
        (MetadataIdentifier.WORLD, True, MetadataName.WORLD),
        (MetadataIdentifier.ALT_ORIGINAL_TITLE, True, MetadataName.ALT_ORIGINAL_TITLE),
        (MetadataIdentifier.SUBTITLE, True, MetadataName.SUBTITLE),
        (MetadataIdentifier.NOTE, True, MetadataName.NOTE)
        ]

TAG_OPTIONS = [
            (MetadataIdentifier.CATEGORY, True, MetadataName.CATEGORY),
            (MetadataIdentifier.PAGES, False, MetadataName.PAGES),
            (MetadataIdentifier.COVER_TYPE, False, MetadataName.COVER_TYPE),
            (MetadataIdentifier.PRINT_RUN, False, MetadataName.PRINT_RUN),
            (MetadataIdentifier.ORIGINAL_TITLE, False, MetadataName.ORIGINAL_TITLE),
            (MetadataIdentifier.TITLE, False, MetadataName.TITLE),
            (MetadataIdentifier.ORIGINAL_YEAR, False, MetadataName.ORIGINAL_YEAR),
            (MetadataIdentifier.PUB_YEAR, False, MetadataName.PUB_YEAR),
            (MetadataIdentifier.ORIGINAL_DATE, False, MetadataName.ORIGINAL_DATE),
            (MetadataIdentifier.PUB_DATE, False, MetadataName.PUB_DATE),
            (MetadataIdentifier.PUBLISHER, False, MetadataName.PUBLISHER),
            (MetadataIdentifier.AUTHORS, False, MetadataName.AUTHORS),
            (MetadataIdentifier.TRANSLATION, False, MetadataName.TRANSLATION),
            (MetadataIdentifier.ILLUSTRATION, False, MetadataName.ILLUSTRATION),
            (MetadataIdentifier.COVER_AUTHORS, False, MetadataName.COVER_AUTHORS),
            (MetadataIdentifier.SERIES, False, MetadataName.SERIES),
            (MetadataIdentifier.EDITION, False, MetadataName.EDITION),
            (MetadataIdentifier.RATING, False, MetadataName.RATING),
            (MetadataIdentifier.RATING10, False, MetadataName.RATING10),
            (MetadataIdentifier.RATING5, False, MetadataName.RATING5),
            (MetadataIdentifier.RATING_COUNT, False, MetadataName.RATING_COUNT),
            (MetadataIdentifier.ISBN, False, MetadataName.ISBN),
            (MetadataIdentifier.ORIG_ID, False, MetadataName.ORIG_ID),
            (MetadataIdentifier.AWARDS, False, MetadataName.AWARDS),
            (MetadataIdentifier.TALES_IN_BOOK, False, MetadataName.TALES_IN_BOOK),
            (MetadataIdentifier.CONTAINED_IN, False, MetadataName.CONTAINED_IN),
            (MetadataIdentifier.SOURCE_RELEVANCE, False, MetadataName.SOURCE_RELEVANCE),
            (MetadataIdentifier.EAN, False, MetadataName.EAN),
            (MetadataIdentifier.PRICE, False, MetadataName.PRICE),
            (MetadataIdentifier.LANGUAGE, False, MetadataName.LANGUAGE),
            (MetadataIdentifier.DIMENSIONS, False, MetadataName.DIMENSIONS),
            (MetadataIdentifier.ISSUE_NUMBER, False, MetadataName.ISSUE_NUMBER),
            (MetadataIdentifier.ALT_TITLE, False, MetadataName.ALT_TITLE),
            (MetadataIdentifier.SEP_PUBLISHED, False, MetadataName.SEP_PUBLISHED),
            (MetadataIdentifier.WORLD, False, MetadataName.WORLD),
            (MetadataIdentifier.ALT_ORIGINAL_TITLE, False, MetadataName.ALT_ORIGINAL_TITLE),
            (MetadataIdentifier.SUBTITLE, False, MetadataName.SUBTITLE),
            (MetadataIdentifier.NOTE, False, MetadataName.NOTE)
        ]

IDENTIFIER_OPTIONS = [
            (MetadataIdentifier.ORIG_ID, True, MetadataName.ORIG_ID, 'legie'),
            (MetadataIdentifier.ISBN, True, MetadataName.ISBN, 'isbn'),
            (MetadataIdentifier.EAN, False, MetadataName.EAN, 'ean'),
            (MetadataIdentifier.RATING, False, MetadataName.RATING, 'leg_rating100'),
            (MetadataIdentifier.RATING10, False, MetadataName.RATING10, 'leg_rating10'),
            (MetadataIdentifier.RATING5, False, MetadataName.RATING5, 'leg_rating5'),
            (MetadataIdentifier.RATING_COUNT, False, MetadataName.RATING_COUNT, 'leg_ratingcount'),
            (MetadataIdentifier.PAGES, False, MetadataName.PAGES, 'leg_pages'),
            (MetadataIdentifier.PRINT_RUN, False, MetadataName.PRINT_RUN, 'leg_printrun'),
            (MetadataIdentifier.ORIGINAL_YEAR, False, MetadataName.ORIGINAL_YEAR, 'leg_origyear'),
            (MetadataIdentifier.ORIGINAL_DATE, False, MetadataName.ORIGINAL_DATE, 'leg_origdate'),
            (MetadataIdentifier.PUB_YEAR, False, MetadataName.PUB_YEAR, 'leg_pubyear'),
            (MetadataIdentifier.PUB_DATE, False, MetadataName.PUB_DATE, 'leg_pubdate'),
            (MetadataIdentifier.COVER_TYPE, False, MetadataName.COVER_TYPE, 'leg_covertype'),
            (MetadataIdentifier.ORIGINAL_TITLE, False, MetadataName.ORIGINAL_TITLE, 'leg_origtitle'),
            (MetadataIdentifier.TITLE, False, MetadataName.TITLE, 'leg_title'),
            (MetadataIdentifier.PUBLISHER, False, MetadataName.PUBLISHER, 'leg_publisher'),
            (MetadataIdentifier.AUTHORS, False, MetadataName.AUTHORS, 'leg_authors'),
            (MetadataIdentifier.TRANSLATION, False, MetadataName.TRANSLATION, 'leg_translators'),
            (MetadataIdentifier.ILLUSTRATION, False, MetadataName.ILLUSTRATION, 'leg_illustrators'),
            (MetadataIdentifier.COVER_AUTHORS, False, MetadataName.COVER_AUTHORS, 'leg_coverauthors'),
            (MetadataIdentifier.SERIES, False, MetadataName.SERIES, 'leg_series'),
            (MetadataIdentifier.EDITION, False, MetadataName.EDITION, 'leg_edition'),
            (MetadataIdentifier.RATING_EMOTIONS, False, MetadataName.RATING_EMOTIONS, 'leg_emotions'),
            (MetadataIdentifier.AWARDS, False, MetadataName.AWARDS, 'leg_awards'),
            (MetadataIdentifier.TALES_IN_BOOK, False, MetadataName.TALES_IN_BOOK, 'leg_bookparts'),
            (MetadataIdentifier.CONTAINED_IN, False, MetadataName.CONTAINED_IN, 'leg_containedin'),
            (MetadataIdentifier.SOURCE_RELEVANCE, False, MetadataName.SOURCE_RELEVANCE, 'leg_relevance'),
            (MetadataIdentifier.PRICE, False, MetadataName.PRICE, 'leg_price'),
            (MetadataIdentifier.LANGUAGE, False, MetadataName.LANGUAGE, 'leg_language'),
            (MetadataIdentifier.DIMENSIONS, False, MetadataName.DIMENSIONS, 'leg_dimensions'),
            (MetadataIdentifier.ISSUE_NUMBER, False, MetadataName.ISSUE_NUMBER, 'leg_issuenumber'),
            (MetadataIdentifier.ALT_TITLE, False, MetadataName.ALT_TITLE, 'leg_alttitle'),
            (MetadataIdentifier.SEP_PUBLISHED, False, MetadataName.SEP_PUBLISHED, 'leg_seppublished'),
            (MetadataIdentifier.WORLD, False, MetadataName.WORLD, 'leg_world'),
            (MetadataIdentifier.ALT_ORIGINAL_TITLE, False, MetadataName.ALT_ORIGINAL_TITLE, 'leg_altoriginaltitle'),
            (MetadataIdentifier.SUBTITLE, False, MetadataName.SUBTITLE, 'leg_subtitle'),
            (MetadataIdentifier.NOTE, False, MetadataName.NOTE, 'leg_note'),
            (MetadataIdentifier.CATEGORY, False, MetadataName.CATEGORY, 'leg_category'),
        ]

COMMENT_OPTIONS = [
        (MetadataIdentifier.DESCRIPTION, True, MetadataName.DESCRIPTION),
        (MetadataIdentifier.HR, True, MetadataName.HR),
        (MetadataIdentifier.PAGES, True, MetadataName.PAGES),
        (MetadataIdentifier.COVER_TYPE, True, MetadataName.COVER_TYPE),
        (MetadataIdentifier.PRINT_RUN, True, MetadataName.PRINT_RUN),
        (MetadataIdentifier.ORIGINAL_TITLE, True, MetadataName.ORIGINAL_TITLE),
        (MetadataIdentifier.TITLE, True, MetadataName.TITLE),
        (MetadataIdentifier.ORIGINAL_YEAR, True, MetadataName.ORIGINAL_YEAR),
        (MetadataIdentifier.PUB_YEAR, True, MetadataName.PUB_YEAR),
        (MetadataIdentifier.ORIGINAL_DATE, True, MetadataName.ORIGINAL_DATE),
        (MetadataIdentifier.PUB_DATE, True, MetadataName.PUB_DATE),
        (MetadataIdentifier.PUBLISHER, True, MetadataName.PUBLISHER),
        (MetadataIdentifier.AUTHORS, True, MetadataName.AUTHORS),
        (MetadataIdentifier.TRANSLATION, True, MetadataName.TRANSLATION),
        (MetadataIdentifier.ILLUSTRATION, True, MetadataName.ILLUSTRATION),
        (MetadataIdentifier.COVER_AUTHORS, True, MetadataName.COVER_AUTHORS),
        (MetadataIdentifier.SERIES, True, MetadataName.SERIES),
        (MetadataIdentifier.EDITION, True, MetadataName.EDITION),
        (MetadataIdentifier.GENRES, True, MetadataName.GENRES),
        (MetadataIdentifier.TAGS, True, MetadataName.TAGS),
        (MetadataIdentifier.RATING, True, MetadataName.RATING),
        (MetadataIdentifier.RATING10, True, MetadataName.RATING10),
        (MetadataIdentifier.RATING5, True, MetadataName.RATING5),
        (MetadataIdentifier.RATING_COUNT, True, MetadataName.RATING_COUNT),
        (MetadataIdentifier.ISBN, True, MetadataName.ISBN),
        (MetadataIdentifier.ORIG_ID, True, MetadataName.ORIG_ID),
        (MetadataIdentifier.AWARDS, True, MetadataName.AWARDS),
        (MetadataIdentifier.TRIVIA, True, MetadataName.TRIVIA),
        (MetadataIdentifier.TALES_IN_BOOK, True, MetadataName.TALES_IN_BOOK),
        (MetadataIdentifier.CONTAINED_IN, True, MetadataName.CONTAINED_IN),
        (MetadataIdentifier.SOURCE_RELEVANCE, True, MetadataName.SOURCE_RELEVANCE),
        (MetadataIdentifier.EAN, True, MetadataName.EAN),
        (MetadataIdentifier.PRICE, True, MetadataName.PRICE),
        (MetadataIdentifier.LANGUAGE, True, MetadataName.LANGUAGE),
        (MetadataIdentifier.DIMENSIONS, True, MetadataName.DIMENSIONS),
        (MetadataIdentifier.ISSUE_NUMBER, True, MetadataName.ISSUE_NUMBER),
        (MetadataIdentifier.ALT_TITLE, True, MetadataName.ALT_TITLE),
        (MetadataIdentifier.SEP_PUBLISHED, True, MetadataName.SEP_PUBLISHED),
        (MetadataIdentifier.WORLD, True, MetadataName.WORLD),
        (MetadataIdentifier.ALT_ORIGINAL_TITLE, True, MetadataName.ALT_ORIGINAL_TITLE),
        (MetadataIdentifier.SUBTITLE, True, MetadataName.SUBTITLE),
        (MetadataIdentifier.NOTE, True, MetadataName.NOTE),
        (MetadataIdentifier.CATEGORY, True, MetadataName.CATEGORY),
        (MetadataIdentifier.EXTERNAL_LINKS, True, MetadataName.EXTERNAL_LINKS),
        ]

DEFAULT_CATEGORY_MAPPINGS = {
                'akční': ['akční'],
                'alternativní historie': ['alternativní historie'],
                'antisemitismus': ['antisemitismus'],
                'antiutopie': ['antiutopie'],
                'antologie': ['antologie'],
                'audiobook': ['audiobook'],
                'bizarro fiction': ['bizarro fiction'],
                'box': ['box'],
                'cestování časem': ['cestování časem'],
                'cyberpunk': ['cyberpunk'],
                'časopis': ['časopis'],
                'dark': ['dark'],
                'detektivní': ['detektivní'],
                'divadelní hra': ['divadelní hra'],
                'dobrodružná': ['dobrodružná'],
                'dospívající': ['dospívající'],
                'draci': ['draci'],
                'duchové': ['duchové'],
                'fanbook': ['fanbook'],
                'fantaskní': ['fantaskní'],
                'fantasy': ['fantasy'],
                'gamebook': ['gamebook'],
                'hard sci-fi': ['hard sci-fi'],
                'historická': ['historická'],
                'horor': ['horor'],
                'hrdinská fantasy': ['hrdinská fantasy'],
                'hry na hrdiny': ['hry na hrdiny'],
                'humorná': ['humorná'],
                'kolonizace vesmíru': ['kolonizace vesmíru'],
                'literární teorie': ['literární teorie'],
                'LitRPG': ['LitRPG'],
                'meč a magie': ['meč a magie'],
                'military': ['military'],
                'mimozemská invaze': ['mimozemská invaze'],
                'New Weird': ['New Weird'],
                'non-category': ['non-category'],
                'nonfiction': ['nonfiction'],
                'omnibus': ['omnibus'],
                'podle filmu/zfilmováno': ['podle filmu/zfilmováno'],
                'podle videohry': ['podle videohry'],
                'postkatastrofická': ['postkatastrofická'],
                'povídková sbírka': ['povídková sbírka'],
                'pro děti a mládež': ['pro děti a mládež'],
                'romantika': ['romantika'],
                'románové antologie': ['románové antologie'],
                'sci-fi': ['sci-fi'],
                'space opera': ['space opera'],
                'spekulativní literatura': ['spekulativní literatura'],
                'steampunk': ['steampunk'],
                'upíři': ['upíři'],
                'urban fantasy': ['urban fantasy'],
                'utopie': ['utopie'],
                'vlkodlaci': ['vlkodlaci'],
                'zombie': ['zombie']
                }

DEFAULT_STORE_VALUES = {
    PluginPrefsName.KEY_MAX_DOWNLOADS: 10,
    PluginPrefsName.MAX_COVERS: 1,
    PluginPrefsName.OBALKYKNIH_COVER: False,
    PluginPrefsName.BOOKPORT_COVER: False,
    PluginPrefsName.IDENTIFIER_SEARCH: True,
    PluginPrefsName.ISBN_SEARCH: True,
    PluginPrefsName.TALES_SEARCH: False,
    PluginPrefsName.GOOGLE_SEARCH: False,
    PluginPrefsName.DUCKDUCKGO_SEARCH: False,
    PluginPrefsName.ISSUE_PREFERENCE: 0,
    PluginPrefsName.AUTHORS_INCLUDE: True,
    PluginPrefsName.TRANSLATORS_INCLUDE: False,
    PluginPrefsName.ILLUSTRATORS_INCLUDE: False,
    PluginPrefsName.COVER_AUTHORS_INCLUDE: False,
    PluginPrefsName.APPEND_TO_COMMENTS: [
        (MetadataIdentifier.DESCRIPTION, True, MetadataName.DESCRIPTION),
    ],
    PluginPrefsName.APPEND_TO_TAG: TAG_OPTIONS,
    PluginPrefsName.APPEND_TO_IDENTIFIERS: IDENTIFIER_OPTIONS,
    PluginPrefsName.SERIES_LOCALIZATION: 0,
    PluginPrefsName.PUBLICATION_DATE: 0,
    PluginPrefsName.SWAP_AUTHORS: False,
    PluginPrefsName.ONE_AUTHOR: False,
    PluginPrefsName.AUTHOR_ROLE: False,
    PluginPrefsName.CALCULATE_RATING: False,
    PluginPrefsName.CALCULATE_RATING_ACCURACY: 3,
    PluginPrefsName.CATEGORY_FILTER: False,
    PluginPrefsName.SERIES_FILTER: False,
    PluginPrefsName.PUBLISHER_FILTER: False,
    PluginPrefsName.PUBLISHER_LINE: [
        (MetadataIdentifier.PUBLISHER, True, MetadataName.PUBLISHER),
    ],
    PluginPrefsName.TITLE_LINE: [
        (MetadataIdentifier.TITLE, True, MetadataName.TITLE),
    ],
    PluginPrefsName.SERIES_LINE: [
        (MetadataIdentifier.SERIES, True, MetadataName.SERIES),
    ],
    PluginPrefsName.SERIES_INDEX_FIELD: (MetadataIdentifier.SERIES_INDEX, True, MetadataName.SERIES_INDEX),
    PluginPrefsName.SERIES_INDEXING_ITEM: 0,
    PluginPrefsName.KEY_SERIES_MAPPINGS: {},
    PluginPrefsName.KEY_CATEGORY_MAPPINGS: copy.deepcopy(DEFAULT_CATEGORY_MAPPINGS),
    PluginPrefsName.KEY_PUBLISHER_MAPPINGS: {}
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/legie')
# Set defaults
plugin_prefs.defaults[PluginPrefsName.STORE_NAME] = DEFAULT_STORE_VALUES

def get_pref(option=None):
    c = plugin_prefs[PluginPrefsName.STORE_NAME]
    if option is not None:
        default_value = plugin_prefs.defaults[PluginPrefsName.STORE_NAME][option]
        return c.get(option, default_value)
    else:
        return plugin_prefs

def set_pref(new_prefs):
    plugin_prefs[PluginPrefsName.STORE_NAME] = new_prefs