#!/bin/bash

# define custom path
COLLECTION_DIR="/mnt/us/documents/Collection"

COLLECTION_FILE="/mnt/us/koreader/settings/collection.lua"
TEMP_FAVORITES="/mnt/us/koreader/settings/favorites_section.tmp"

restore_backup() {
    BACKUP_FILE="${COLLECTION_FILE}.bkp"

    if [ ! -f "$BACKUP_FILE" ]; then
        fbink -pm -y -5 -F TERMINUS "!!! ERROR !!!" "Backup file $BACKUP_FILE not found!"
        exit 1
    fi

    cp "$BACKUP_FILE" "$COLLECTION_FILE"
    if [ $? -eq 0 ]; then
        fbink -pm -y -5 -F TERMINUS "Congrats!" "Backup successfully restored"
        exit 0
    else
        fbink -pm -y -5 -F TERMINUS "!!! ERROR !!!" "Failed to restore backup"
        echo "Error: Failed to restore the backup."
        exit 1
    fi
}

if [ "$1" == "--restore" ]; then
    restore_backup
    exit 0
fi

if [ -f "$COLLECTION_FILE" ]; then
    cp "$COLLECTION_FILE" "$COLLECTION_FILE.bkp"
else
    fbink -pm -y -5 -F TERMINUS "!!! ERROR !!!" "${COLLECTION_FILE##*/} not found!"
    exit 1
fi

if [ ! -d "$COLLECTION_DIR" ]; then
    fbink -pm -y -5 -F TERMINUS "!!! ERROR !!!" "$COLLECTION_DIR not found!"
    exit 1
fi

if grep -q '\["favorites"\]' "$COLLECTION_FILE"; then
    sed -n '/\["favorites"\] = {/,/^    },/p' "$COLLECTION_FILE" > "$TEMP_FAVORITES"
else
    cat <<EOL > "$TEMP_FAVORITES"
    ["favorites"] = {
        ["settings"] = {
            ["order"] = 1,
        },
    },
EOL
fi

order_counter=2

add_to_collection() {
    local file="$1"
    local item_order="$2"

    echo "        [$item_order] = {" >> "$COLLECTION_FILE"
    echo "            [\"file\"] = \"$file\"," >> "$COLLECTION_FILE"
    echo "            [\"order\"] = $item_order," >> "$COLLECTION_FILE"
    echo "        }," >> "$COLLECTION_FILE"
}

create_collection() {
    local collection_name="$1"
    local item_order=1

    echo "    [\"$collection_name\"] = {" >> "$COLLECTION_FILE"

find "$COLLECTION_DIR/$collection_name" -type f \( -iname "*.epub" -o -iname "*.mobi" -o -iname "*.azw3" -o -iname "*.pdf" -o -iname "*.txt" -o -iname "*.fb2" -o -iname "*.lit" -o -iname "*.lrf" -o -iname "*.html" \) \
    | sort -t '/' -k2,2 -n | while read -r file; do
    if [ -f "$file" ]; then
        add_to_collection "$file" "$item_order"
        item_order=$((item_order + 1))
    fi
done

    echo "        [\"settings\"] = {" >> "$COLLECTION_FILE"
    echo "            [\"order\"] = $order_counter," >> "$COLLECTION_FILE"
    echo "        }," >> "$COLLECTION_FILE"
    echo "    }," >> "$COLLECTION_FILE"
    
    order_counter=$((order_counter + 1))
}

{
    echo "-- ./settings/collection.lua"
    echo "return {"
} > "$COLLECTION_FILE"

for dir in "$COLLECTION_DIR"/*; do
    if [ -d "$dir" ]; then
        collection_name=$(basename "$dir")
        create_collection "$collection_name"
    fi
done

cat "$TEMP_FAVORITES" >> "$COLLECTION_FILE"

echo "}" >> "$COLLECTION_FILE"

rm -f "$TEMP_FAVORITES"

fbink -pm -y -5 -F TERMINUS "Congrats!" "Collection created successfully"
