import re
import os

def split_paragraphs(path_to_ebook):
    try:
        ext = os.path.splitext(path_to_ebook)[1].lower()
        if ext not in ['.txt', '.epub']:
            raise ValueError(f"Unsupported file type: {ext}")
        
        with open(path_to_ebook, 'r', encoding='utf-8') as file:
            content = file.read()

        lines = content.splitlines()
        new_content = []
        paragraph = []

        for line in lines:
            paragraph.append(line.strip())
            if len(paragraph) == 4:
                if not re.search(r'[.!?]$', line):
                    while len(lines) > 0:
                        next_line = lines.pop(0).strip()
                        paragraph.append(next_line)
                        if re.search(r'[.!?]$', next_line):
                            break
                new_content.append(' '.join(paragraph))
                paragraph = []

        if paragraph:
            new_content.append(' '.join(paragraph))

        new_content = '\n\n'.join(new_content)

        with open(path_to_ebook, 'w', encoding='utf-8') as file:
            file.write(new_content)

    except Exception as e:
        print(f"An error occurred: {e}")
